/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.CaseUtils;
import cool.scx.common.util.MultiMap;
import cool.scx.data.jdbc.AnnotationConfigColumn;
import cool.scx.data.jdbc.annotation.NoColumn;
import cool.scx.data.jdbc.annotation.Table;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ReflectFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class AnnotationConfigTable
implements cool.scx.jdbc.mapping.Table {
    private final AnnotationConfigColumn[] columns;
    private final String name;
    private final Map<String, AnnotationConfigColumn> columnMap;

    public AnnotationConfigTable(Class<?> clazz) {
        this.name = AnnotationConfigTable.initTableName(clazz);
        this.columns = AnnotationConfigTable.initAllColumns(clazz);
        this.columnMap = AnnotationConfigTable.initAllColumnMap(this.columns);
    }

    public static String initTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        String defaultTableName = CaseUtils.toSnake((String)clazz.getSimpleName());
        if (table != null) {
            String _tableName = AnnotationUtils.getAnnotationValue((String)table.tableName());
            String _tablePrefix = AnnotationUtils.getAnnotationValue((String)table.tablePrefix());
            if (_tableName != null) {
                return _tableName;
            }
            if (_tablePrefix != null) {
                return _tablePrefix + "_" + defaultTableName;
            }
        }
        return "scx_" + defaultTableName;
    }

    private static AnnotationConfigColumn[] initAllColumns(Class<?> clazz) {
        ClassInfo classInfo = ReflectFactory.getClassInfo(clazz);
        FieldInfo[] fields = classInfo.isRecord() ? classInfo.allFields() : (FieldInfo[])Stream.of(classInfo.allFields()).filter(c -> c.accessModifier() == AccessModifier.PUBLIC).toArray(FieldInfo[]::new);
        List<AnnotationConfigColumn> list = Stream.of(fields).filter(field -> field.getAnnotation(NoColumn.class) == null).map(AnnotationConfigColumn::new).toList();
        AnnotationConfigTable.checkDuplicateColumnName(list, clazz);
        return (AnnotationConfigColumn[])list.toArray(AnnotationConfigColumn[]::new);
    }

    private static Map<String, AnnotationConfigColumn> initAllColumnMap(AnnotationConfigColumn[] infos) {
        HashMap<String, AnnotationConfigColumn> map = new HashMap<String, AnnotationConfigColumn>();
        for (AnnotationConfigColumn info : infos) {
            map.put(info.name(), info);
        }
        for (AnnotationConfigColumn info : infos) {
            map.put(info.javaField().name(), info);
        }
        return map;
    }

    private static void checkDuplicateColumnName(List<AnnotationConfigColumn> list, Class<?> clazz) {
        MultiMap multiMap = new MultiMap();
        for (AnnotationConfigColumn info : list) {
            multiMap.put((Object)info.name(), (Object)info);
        }
        Map map = multiMap.toMultiValueMap();
        for (Map.Entry entry : map.entrySet()) {
            List v = (List)entry.getValue();
            if (v.size() <= 1) continue;
            throw new IllegalArgumentException("\u91cd\u590d\u7684 columnName !!! Class -> " + clazz.getName() + ", Field -> " + String.valueOf(v.stream().map(c -> c.javaField().name()).toList()));
        }
    }

    public String name() {
        return this.name;
    }

    public AnnotationConfigColumn[] columns() {
        return this.columns;
    }

    public AnnotationConfigColumn getColumn(String column) {
        return this.columnMap.get(column);
    }
}

