/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.data.Dao;
import cool.scx.data.field_filter.FieldFilter;
import cool.scx.data.jdbc.AnnotationConfigColumn;
import cool.scx.data.jdbc.AnnotationConfigTable;
import cool.scx.data.jdbc.JDBCDaoHelper;
import cool.scx.data.jdbc.parser.JDBCDaoGroupByParser;
import cool.scx.data.jdbc.parser.JDBCDaoOrderByParser;
import cool.scx.data.jdbc.parser.JDBCDaoWhereParser;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLBuilder;
import cool.scx.jdbc.sql.SQLRunner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class JDBCDao<Entity>
implements Dao<Entity, Long> {
    protected final AnnotationConfigTable tableInfo;
    protected final Class<Entity> entityClass;
    protected final SQLRunner sqlRunner;
    protected final ResultHandler<List<Entity>> entityBeanListHandler;
    protected final ResultHandler<Entity> entityBeanHandler;
    protected final ResultHandler<Long> countResultHandler;
    protected final JDBCDaoWhereParser whereParser;
    protected final JDBCDaoGroupByParser groupByParser;
    protected final JDBCDaoOrderByParser orderByParser;
    protected final JDBCContext jdbcContext;
    protected final Function<Field, String> columnNameMapping;
    protected final BeanBuilder<Entity> beanBuilder;

    public JDBCDao(Class<Entity> entityClass, JDBCContext jdbcContext) {
        this.entityClass = entityClass;
        this.jdbcContext = jdbcContext;
        this.sqlRunner = jdbcContext.sqlRunner();
        this.tableInfo = new AnnotationConfigTable(entityClass);
        this.columnNameMapping = field -> {
            AnnotationConfigColumn columnInfo = this.tableInfo.getColumn(field.getName());
            return columnInfo == null ? null : columnInfo.name();
        };
        this.beanBuilder = BeanBuilder.of(this.entityClass, this.columnNameMapping);
        this.entityBeanListHandler = ResultHandler.ofBeanList(this.beanBuilder);
        this.entityBeanHandler = ResultHandler.ofBean(this.beanBuilder);
        this.countResultHandler = ResultHandler.ofSingleValue((String)"count", Long.class);
        this.whereParser = new JDBCDaoWhereParser(this.tableInfo, jdbcContext.dialect());
        this.groupByParser = new JDBCDaoGroupByParser(this.tableInfo);
        this.orderByParser = new JDBCDaoOrderByParser(this.tableInfo);
    }

    public final Long add(Entity entity, FieldFilter updateFilter) {
        return this.sqlRunner.update(this.buildInsertSQL(entity, updateFilter)).firstGeneratedKey();
    }

    public final List<Long> add(Collection<Entity> entityList, FieldFilter updateFilter) {
        return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, updateFilter)).generatedKeys();
    }

    public final List<Entity> find(Query query, FieldFilter selectFilter) {
        return (List)this.sqlRunner.query(this.buildSelectSQL(query, selectFilter), this.entityBeanListHandler);
    }

    public void find(Query query, FieldFilter fieldFilter, Consumer<Entity> consumer) {
        this.sqlRunner.query(this.buildSelectSQL(query, fieldFilter), ResultHandler.ofBeanConsumer(this.beanBuilder, consumer));
    }

    public Entity get(Query query, FieldFilter columnFilter) {
        return (Entity)this.sqlRunner.query(this.buildGetSQL(query, columnFilter), this.entityBeanHandler);
    }

    public final long update(Entity entity, Query query, FieldFilter updateFilter) {
        return this.sqlRunner.update(this.buildUpdateSQL(entity, query, updateFilter)).affectedItemsCount();
    }

    public final long delete(Query query) {
        return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
    }

    public final long count(Query query) {
        return (Long)this.sqlRunner.query(this.buildCountSQL(query), this.countResultHandler);
    }

    public final void clear() {
        this.sqlRunner.execute(SQL.sql((String)("truncate " + this.tableInfo.name()), (Object[])new Object[0]));
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final AnnotationConfigTable tableInfo() {
        return this.tableInfo;
    }

    public final SQLRunner sqlRunner() {
        return this.sqlRunner;
    }

    public BeanBuilder<Entity> beanBuilder() {
        return this.beanBuilder;
    }

    public ResultHandler<List<Entity>> entityBeanListHandler() {
        return this.entityBeanListHandler;
    }

    public ResultHandler<Entity> entityBeanHandler() {
        return this.entityBeanHandler;
    }

    private String _buildInsertSQL0(Column[] insertColumns) {
        String[] insertValues = (String[])Arrays.stream(insertColumns).map(columnInfo -> "?").toArray(String[]::new);
        return SQLBuilder.Insert((Table)this.tableInfo, (Column[])insertColumns).Values(insertValues).GetSQL(this.jdbcContext.dialect());
    }

    private SQL buildInsertSQL(Entity entity, FieldFilter updateFilter) {
        AnnotationConfigColumn[] insertColumnInfos = JDBCDaoHelper.filter(updateFilter, entity, this.tableInfo);
        String sql = this._buildInsertSQL0((Column[])insertColumnInfos);
        Object[] objectArray = Arrays.stream(insertColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.sql((String)sql, (Object[])objectArray);
    }

    private SQL buildInsertBatchSQL(Collection<? extends Entity> entityList, FieldFilter updateFilter) {
        AnnotationConfigColumn[] insertColumnInfos = JDBCDaoHelper.filter(updateFilter, this.tableInfo);
        ArrayList<Object[]> objectArrayList = new ArrayList<Object[]>();
        for (Entity entity : entityList) {
            Object[] o = new Object[insertColumnInfos.length];
            for (int i = 0; i < insertColumnInfos.length; ++i) {
                o[i] = insertColumnInfos[i].javaFieldValue(entity);
            }
            objectArrayList.add(o);
        }
        String sql = this._buildInsertSQL0((Column[])insertColumnInfos);
        return SQL.sql((String)sql, objectArrayList);
    }

    private String _buildSelectSQL0(Query query, FieldFilter selectFilter, WhereClause whereClause) {
        AnnotationConfigColumn[] selectColumns = JDBCDaoHelper.filter(selectFilter, this.tableInfo);
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        return SQLBuilder.Select((Column[])selectColumns).From((Table)this.tableInfo).Where(whereClause.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.getOffset(), query.getLimit()).GetSQL(this.jdbcContext.dialect());
    }

    public final SQL buildSelectSQL(Query query, FieldFilter selectFilter) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String sql = this._buildSelectSQL0(query, selectFilter, whereClause);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public final SQL buildSelectSQLWithAlias(Query query, FieldFilter selectFilter) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String sql0 = this._buildSelectSQL0(query, selectFilter, whereClause);
        String sql = SQLBuilder.Select((String[])new String[]{"*"}).From("(" + sql0 + ")").GetSQL(this.jdbcContext.dialect());
        return SQL.sql((String)(sql + " AS " + this.tableInfo.name() + "_" + RandomUtils.randomString((int)6)), (Object[])whereClause.params());
    }

    private String _buildGetSQL0(Query query, FieldFilter selectFilter, WhereClause whereClause) {
        AnnotationConfigColumn[] selectColumns = JDBCDaoHelper.filter(selectFilter, this.tableInfo);
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        return SQLBuilder.Select((Column[])selectColumns).From((Table)this.tableInfo).Where(whereClause.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(null, Long.valueOf(1L)).GetSQL(this.jdbcContext.dialect());
    }

    public final SQL buildGetSQL(Query query, FieldFilter selectFilter) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String sql = this._buildGetSQL0(query, selectFilter, whereClause);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public final SQL buildGetSQLWithAlias(Query query, FieldFilter selectFilter) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String sql0 = this._buildGetSQL0(query, selectFilter, whereClause);
        String sql = SQLBuilder.Select((String[])new String[]{"*"}).From("(" + sql0 + ")").GetSQL(this.jdbcContext.dialect());
        return SQL.sql((String)(sql + " AS " + this.tableInfo.name() + "_" + RandomUtils.randomString((int)6)), (Object[])whereClause.params());
    }

    private SQL buildUpdateSQL(Entity entity, Query query, FieldFilter updateFilter) {
        if (query.getWhere().length == 0) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        AnnotationConfigColumn[] updateSetColumnInfos = JDBCDaoHelper.filter(updateFilter, entity, this.tableInfo);
        String[] updateSetColumns = (String[])Arrays.stream(updateSetColumnInfos).map(c -> c.name() + " = ?").toArray(String[]::new);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        String sql = SQLBuilder.Update((Table)this.tableInfo).Set(updateSetColumns).Where(whereClause.whereClause()).OrderBy(orderByClauses).Limit(null, query.getLimit()).GetSQL(this.jdbcContext.dialect());
        Object[] entityParams = Arrays.stream(updateSetColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.sql((String)sql, (Object[])ArrayUtils.concat((Object[])entityParams, (Object[])whereClause.params()));
    }

    private SQL buildDeleteSQL(Query query) {
        if (query.getWhere().length == 0) {
            throw new IllegalArgumentException("\u5220\u9664\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        String sql = SQLBuilder.Delete((Table)this.tableInfo).Where(whereClause.whereClause()).OrderBy(orderByClauses).Limit(null, query.getLimit()).GetSQL(this.jdbcContext.dialect());
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    private SQL buildCountSQL(Query query) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String sql = SQLBuilder.Select((String[])new String[]{"COUNT(*) AS count"}).From((Table)this.tableInfo).Where(whereClause.whereClause()).GroupBy(groupByColumns).GetSQL(this.jdbcContext.dialect());
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }
}

