/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ClassUtils;
import cool.scx.data.field_filter.FieldFilter;
import cool.scx.data.jdbc.AnnotationConfigColumn;
import cool.scx.data.jdbc.AnnotationConfigTable;
import cool.scx.jdbc.JDBCType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public final class JDBCDaoHelper {
    public static AnnotationConfigColumn[] filter(FieldFilter fieldFilter, AnnotationConfigTable tableInfo) {
        AnnotationConfigColumn[] annotationConfigColumnArray;
        if (fieldFilter.getFieldNames().length == 0) {
            switch (fieldFilter.getFilterMode()) {
                default: {
                    throw new MatchException(null, null);
                }
                case INCLUDED: {
                    annotationConfigColumnArray = new AnnotationConfigColumn[]{};
                    break;
                }
                case EXCLUDED: {
                    annotationConfigColumnArray = tableInfo.columns();
                    break;
                }
            }
        } else {
            switch (fieldFilter.getFilterMode()) {
                default: {
                    throw new MatchException(null, null);
                }
                case INCLUDED: {
                    ArrayList<AnnotationConfigColumn> list = new ArrayList<AnnotationConfigColumn>();
                    for (String fieldName : fieldFilter.getFieldNames()) {
                        list.add(tableInfo.getColumn(fieldName));
                    }
                    annotationConfigColumnArray = (AnnotationConfigColumn[])list.toArray(AnnotationConfigColumn[]::new);
                    break;
                }
                case EXCLUDED: {
                    ArrayList<AnnotationConfigColumn> objects = new ArrayList<AnnotationConfigColumn>(Arrays.asList(tableInfo.columns()));
                    for (String fieldName : fieldFilter.getFieldNames()) {
                        objects.remove(tableInfo.getColumn(fieldName));
                    }
                    annotationConfigColumnArray = (AnnotationConfigColumn[])objects.toArray(AnnotationConfigColumn[]::new);
                    break;
                }
            }
        }
        return annotationConfigColumnArray;
    }

    public static AnnotationConfigColumn[] filter(FieldFilter fieldFilter, Object entity, AnnotationConfigTable tableInfo) {
        return fieldFilter.getIgnoreNullValue() ? JDBCDaoHelper.excludeIfFieldValueIsNull(entity, JDBCDaoHelper.filter(fieldFilter, tableInfo)) : JDBCDaoHelper.filter(fieldFilter, tableInfo);
    }

    private static AnnotationConfigColumn[] excludeIfFieldValueIsNull(Object entity, AnnotationConfigColumn ... scxDaoColumnInfos) {
        return (AnnotationConfigColumn[])Arrays.stream(scxDaoColumnInfos).filter(field -> field.javaFieldValue(entity) != null).toArray(AnnotationConfigColumn[]::new);
    }

    public static JDBCType getDataTypeByJavaType(Type type) {
        JavaType javaType;
        JDBCType c;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            JDBCType c2 = JDBCDaoHelper.getDataTypeByJavaType0(clazz);
            if (c2 != null) {
                return c2;
            }
        } else if (type instanceof JavaType && (c = JDBCDaoHelper.getDataTypeByJavaType0((javaType = (JavaType)type).getRawClass())) != null) {
            return c;
        }
        return JDBCType.JSON;
    }

    private static JDBCType getDataTypeByJavaType0(Class<?> clazz) {
        if (ClassUtils.isEnum(clazz)) {
            return JDBCType.VARCHAR;
        }
        return JDBCType.getByJavaType(clazz);
    }
}

