/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;

public final class ColumnNameParser {
    public static String parseColumnName(Table tableInfo, String name, boolean useJsonExtract, boolean useOriginalName) {
        if (useJsonExtract) {
            ColumnNameAndFieldPath c = ColumnNameParser.splitIntoColumnNameAndFieldPath(name);
            if (StringUtils.notBlank((String)c.columnName()) && StringUtils.notBlank((String)c.fieldPath())) {
                String jsonQueryColumnName = useOriginalName ? c.columnName() : tableInfo.getColumn(c.columnName()).name();
                return jsonQueryColumnName + " -> '$" + c.fieldPath() + "'";
            }
            throw new IllegalArgumentException("\u4f7f\u7528 USE_JSON_EXTRACT \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
        }
        if (useOriginalName) {
            return name;
        }
        Column column = tableInfo.getColumn(name);
        if (column == null) {
            throw new IllegalArgumentException("\u5728 Table : " + tableInfo.name() + " \u4e2d , \u672a\u627e\u5230\u5bf9\u5e94 name \u4e3a : " + name + " \u7684\u5217 !!!");
        }
        return column.name();
    }

    public static ColumnNameAndFieldPath splitIntoColumnNameAndFieldPath(String name) {
        char[] charArray = name.toCharArray();
        int index = charArray.length;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '.' && c != '[') continue;
            index = i;
            break;
        }
        String columnName = name.substring(0, index);
        String fieldPath = name.substring(index);
        return new ColumnNameAndFieldPath(columnName, fieldPath);
    }

    public record ColumnNameAndFieldPath(String columnName, String fieldPath) {
    }
}

