/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.Finder;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.jdbc.result_handler.ResultHandler;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class JDBCFinder<Entity>
implements Finder<Entity> {
    private final JDBCRepository<Entity> repository;
    private final Query query;
    private final FieldPolicy fieldPolicy;

    public JDBCFinder(JDBCRepository<Entity> repository, Query query, FieldPolicy fieldPolicy) {
        this.repository = repository;
        this.query = query;
        this.fieldPolicy = fieldPolicy;
    }

    public List<Entity> list() {
        return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), this.repository.entityBeanListHandler);
    }

    public <T> List<T> list(Class<T> resultType) {
        return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), ResultHandler.ofBeanList(resultType, (Function)this.repository.columnNameMapping));
    }

    public List<Map<String, Object>> mapList() {
        return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), ResultHandler.ofMapList());
    }

    public void forEach(Consumer<Entity> entityConsumer) {
        this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), ResultHandler.ofBeanConsumer(this.repository.beanBuilder, entityConsumer));
    }

    public <T> void forEach(Consumer<T> entityConsumer, Class<T> resultType) {
        this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), ResultHandler.ofBeanConsumer(resultType, (Function)this.repository.columnNameMapping, entityConsumer));
    }

    public void forEachMap(Consumer<Map<String, Object>> entityConsumer) {
        this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy), ResultHandler.ofMapConsumer(entityConsumer));
    }

    public Entity first() {
        return (Entity)this.repository.sqlRunner.query(this.repository.buildGetSQL(this.query, this.fieldPolicy), this.repository.entityBeanHandler);
    }

    public <T> T first(Class<T> resultType) {
        return (T)this.repository.sqlRunner.query(this.repository.buildGetSQL(this.query, this.fieldPolicy), ResultHandler.ofBean(resultType, (Function)this.repository.columnNameMapping));
    }

    public Map<String, Object> firstMap() {
        return (Map)this.repository.sqlRunner.query(this.repository.buildGetSQL(this.query, this.fieldPolicy), ResultHandler.ofMap());
    }

    public long count() {
        return (Long)this.repository.sqlRunner.query(this.repository.buildCountSQL(this.query), this.repository.countResultHandler);
    }
}

