/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.Finder;
import cool.scx.data.Repository;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.JDBCFinder;
import cool.scx.data.jdbc.column_name_mapping.FieldColumnNameMapping;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.parser.JDBCGroupByParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.CountSQLBuilder;
import cool.scx.data.jdbc.sql_builder.DeleteSQLBuilder;
import cool.scx.data.jdbc.sql_builder.InsertSQLBuilder;
import cool.scx.data.jdbc.sql_builder.SelectSQLBuilder;
import cool.scx.data.jdbc.sql_builder.UpdateSQLBuilder;
import cool.scx.data.query.Query;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLRunner;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class JDBCRepository<Entity>
implements Repository<Entity, Long> {
    final Class<Entity> entityClass;
    final JDBCContext jdbcContext;
    final AnnotationConfigTable table;
    final SQLRunner sqlRunner;
    final FieldColumnNameMapping columnNameMapping;
    final BeanBuilder<Entity> beanBuilder;
    final ResultHandler<List<Entity>> entityBeanListHandler;
    final ResultHandler<Entity> entityBeanHandler;
    final ResultHandler<Long> countResultHandler;
    final InsertSQLBuilder insertSQLBuilder;
    final SelectSQLBuilder selectSQLBuilder;
    final UpdateSQLBuilder updateSQLBuilder;
    final DeleteSQLBuilder deleteSQLBuilder;
    final CountSQLBuilder countSQLBuilder;

    public JDBCRepository(Class<Entity> entityClass, JDBCContext jdbcContext) {
        this.entityClass = entityClass;
        this.jdbcContext = jdbcContext;
        this.table = new AnnotationConfigTable(entityClass);
        this.sqlRunner = jdbcContext.sqlRunner();
        this.columnNameMapping = new FieldColumnNameMapping(this.table);
        this.beanBuilder = BeanBuilder.of(this.entityClass, (Function)this.columnNameMapping);
        this.entityBeanListHandler = ResultHandler.ofBeanList(this.beanBuilder);
        this.entityBeanHandler = ResultHandler.ofBean(this.beanBuilder);
        this.countResultHandler = ResultHandler.ofSingleValue((String)"count", Long.class);
        Dialect dialect = jdbcContext.dialect();
        JDBCColumnNameParser columnNameParser = new JDBCColumnNameParser(this.table, dialect);
        JDBCWhereParser whereParser = new JDBCWhereParser(columnNameParser);
        JDBCGroupByParser groupByParser = new JDBCGroupByParser(columnNameParser);
        JDBCOrderByParser orderByParser = new JDBCOrderByParser(columnNameParser);
        this.insertSQLBuilder = new InsertSQLBuilder(this.table, dialect, columnNameParser);
        this.selectSQLBuilder = new SelectSQLBuilder(this.table, dialect, whereParser, groupByParser, orderByParser);
        this.updateSQLBuilder = new UpdateSQLBuilder(this.table, dialect, columnNameParser, whereParser, orderByParser);
        this.deleteSQLBuilder = new DeleteSQLBuilder(this.table, dialect, whereParser, orderByParser);
        this.countSQLBuilder = new CountSQLBuilder(this.table, dialect, whereParser, groupByParser);
    }

    public final Long add(Entity entity, FieldPolicy fieldPolicy) {
        return this.sqlRunner.update(this.buildInsertSQL(entity, fieldPolicy)).firstGeneratedKey();
    }

    public final List<Long> add(Collection<Entity> entityList, FieldPolicy fieldPolicy) {
        return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, fieldPolicy)).generatedKeys();
    }

    public final Finder<Entity> finder(Query query, FieldPolicy fieldPolicy) {
        return new JDBCFinder(this, query, fieldPolicy);
    }

    public final long update(Entity entity, FieldPolicy fieldPolicy, Query query) {
        return this.sqlRunner.update(this.buildUpdateSQL(entity, fieldPolicy, query)).affectedItemsCount();
    }

    public final long delete(Query query) {
        return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
    }

    public final void clear() {
        this.sqlRunner.execute(SQL.sql((String)("truncate " + this.table.name()), (Object[])new Object[0]));
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final AnnotationConfigTable table() {
        return this.table;
    }

    public final SQLRunner sqlRunner() {
        return this.sqlRunner;
    }

    public BeanBuilder<Entity> beanBuilder() {
        return this.beanBuilder;
    }

    public ResultHandler<List<Entity>> entityBeanListHandler() {
        return this.entityBeanListHandler;
    }

    public ResultHandler<Entity> entityBeanHandler() {
        return this.entityBeanHandler;
    }

    public JDBCContext jdbcContext() {
        return this.jdbcContext;
    }

    public SQL buildInsertSQL(Entity entity, FieldPolicy fieldPolicy) {
        return this.insertSQLBuilder.buildInsertSQL(entity, fieldPolicy);
    }

    public SQL buildInsertBatchSQL(Collection<? extends Entity> entityList, FieldPolicy fieldPolicy) {
        return this.insertSQLBuilder.buildInsertBatchSQL(entityList, fieldPolicy);
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectSQL(query, fieldPolicy);
    }

    public SQL buildGetSQL(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildGetSQL(query, fieldPolicy);
    }

    public SQL buildUpdateSQL(Entity entity, FieldPolicy fieldPolicy, Query query) {
        return this.updateSQLBuilder.buildUpdateSQL(entity, fieldPolicy, query);
    }

    public SQL buildDeleteSQL(Query query) {
        return this.deleteSQLBuilder.buildDeleteSQL(query);
    }

    public SQL buildCountSQL(Query query) {
        return this.countSQLBuilder.buildCountSQL(query);
    }

    public SQL buildGetSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildGetSQLWithAlias(query, fieldPolicy);
    }

    public SQL buildSelectSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectSQLWithAlias(query, fieldPolicy);
    }
}

