/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.data.jdbc.parser.JDBCGroupByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLBuilder;

public class CountSQLBuilder {
    private final JDBCWhereParser whereParser;
    private final JDBCGroupByParser groupByParser;
    private final Table table;
    private final Dialect dialect;

    public CountSQLBuilder(Table table, Dialect dialect, JDBCWhereParser whereParser, JDBCGroupByParser groupByParser) {
        this.whereParser = whereParser;
        this.groupByParser = groupByParser;
        this.table = table;
        this.dialect = dialect;
    }

    public SQL buildCountSQL(Query query) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String sql = SQLBuilder.Select((Object[])new Object[]{"COUNT(*) AS count"}).From((Object)this.table).Where(whereClause.whereClause()).GroupBy(groupByColumns).GetSQL(this.dialect);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }
}

