/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InsertSQLBuilder {
    private final AnnotationConfigTable table;
    private final Dialect dialect;
    private final JDBCColumnNameParser columnNameParser;

    public InsertSQLBuilder(AnnotationConfigTable table, Dialect dialect, JDBCColumnNameParser columnNameParser) {
        this.table = table;
        this.dialect = dialect;
        this.columnNameParser = columnNameParser;
    }

    public static String[] createInsertExpressionsColumns(FieldPolicy fieldPolicy, JDBCColumnNameParser parser) {
        Map fieldExpressions = fieldPolicy.expressions();
        Set fieldNames = fieldExpressions.keySet();
        String[] result = new String[fieldNames.size()];
        int i = 0;
        for (String fieldName : fieldNames) {
            result[i] = parser.parseColumnName(fieldName, false);
            ++i;
        }
        return result;
    }

    public static String[] createInsertValues(Column[] columns) {
        String[] result = new String[columns.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = "?";
        }
        return result;
    }

    public static String[] createInsertExpressionsValue(FieldPolicy fieldPolicy) {
        Map fieldExpressions = fieldPolicy.expressions();
        Collection expressions = fieldExpressions.values();
        String[] result = new String[expressions.size()];
        int i = 0;
        Iterator iterator = expressions.iterator();
        while (iterator.hasNext()) {
            String expression;
            result[i] = expression = (String)iterator.next();
            ++i;
        }
        return result;
    }

    public SQL buildInsertSQL(Object entity, FieldPolicy fieldPolicy) {
        Object[] insertColumns = SQLBuilderHelper.filterByFieldPolicy(fieldPolicy, this.table, entity);
        String[] insertExpressionsColumns = InsertSQLBuilder.createInsertExpressionsColumns(fieldPolicy, this.columnNameParser);
        Object[] insertValues = InsertSQLBuilder.createInsertValues((Column[])insertColumns);
        Object[] insertExpressionsValue = InsertSQLBuilder.createInsertExpressionsValue(fieldPolicy);
        Object[] finalInsertColumns = ArrayUtils.tryConcatAny((Object[])insertColumns, (Object[])insertExpressionsColumns);
        String[] finalInsertValues = (String[])ArrayUtils.tryConcat((Object[])insertValues, (Object[])insertExpressionsValue);
        String sql = SQLBuilder.Insert((Object)this.table, (Object[])finalInsertColumns).Values(finalInsertValues).GetSQL(this.dialect);
        Object[] params = SQLBuilderHelper.extractValues((AnnotationConfigColumn[])insertColumns, entity);
        return SQL.sql((String)sql, (Object[])params);
    }

    public SQL buildInsertBatchSQL(Collection<?> entityList, FieldPolicy fieldPolicy) {
        Object[] insertColumns = SQLBuilderHelper.filterByFieldPolicy(fieldPolicy, this.table);
        String[] insertExpressionsColumns = InsertSQLBuilder.createInsertExpressionsColumns(fieldPolicy, this.columnNameParser);
        Object[] insertValues = InsertSQLBuilder.createInsertValues((Column[])insertColumns);
        Object[] insertExpressionsValue = InsertSQLBuilder.createInsertExpressionsValue(fieldPolicy);
        Object[] finalInsertColumns = ArrayUtils.tryConcatAny((Object[])insertColumns, (Object[])insertExpressionsColumns);
        String[] finalInsertValues = (String[])ArrayUtils.tryConcat((Object[])insertValues, (Object[])insertExpressionsValue);
        String sql = SQLBuilder.Insert((Object)this.table, (Object[])finalInsertColumns).Values(finalInsertValues).GetSQL(this.dialect);
        ArrayList<Object[]> batchParams = new ArrayList<Object[]>(entityList.size());
        for (Object entity : entityList) {
            batchParams.add(SQLBuilderHelper.extractValues((AnnotationConfigColumn[])insertColumns, entity));
        }
        return SQL.sql((String)sql, batchParams);
    }
}

