/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class SQLBuilderHelper {
    public static AnnotationConfigColumn[] filterByFieldPolicy(FieldPolicy fieldPolicy, AnnotationConfigTable table, Object entity) {
        AnnotationConfigColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        Map fieldExpressions = fieldPolicy.expressions();
        columns = SQLBuilderHelper.filterByFieldExpressions(fieldExpressions, table, columns);
        boolean globalIgnoreNull = fieldPolicy.ignoreNull();
        Map ignoreNulls = fieldPolicy.ignoreNulls();
        columns = SQLBuilderHelper.filterByFieldValueIsNull(entity, globalIgnoreNull, ignoreNulls, columns);
        return columns;
    }

    public static AnnotationConfigColumn[] filterByFieldPolicy(FieldPolicy fieldPolicy, AnnotationConfigTable table) {
        AnnotationConfigColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        Map fieldExpressions = fieldPolicy.expressions();
        return SQLBuilderHelper.filterByFieldExpressions(fieldExpressions, table, columns);
    }

    public static AnnotationConfigColumn[] filterByFilterMode(FieldPolicy fieldPolicy, AnnotationConfigTable table) {
        FilterMode filterMode = fieldPolicy.filterMode();
        return switch (filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> SQLBuilderHelper.filterByIncluded(fieldPolicy.fieldNames(), table);
            case FilterMode.EXCLUDED -> SQLBuilderHelper.filterByExcluded(fieldPolicy.fieldNames(), table);
        };
    }

    public static AnnotationConfigColumn[] filterByIncluded(String[] fieldNames, AnnotationConfigTable table) {
        if (fieldNames.length == 0) {
            return new AnnotationConfigColumn[0];
        }
        ArrayList<AnnotationConfigColumn> columns = new ArrayList<AnnotationConfigColumn>();
        for (String fieldName : fieldNames) {
            columns.add(table.getColumn(fieldName));
        }
        return (AnnotationConfigColumn[])columns.toArray(AnnotationConfigColumn[]::new);
    }

    public static AnnotationConfigColumn[] filterByExcluded(String[] fieldNames, AnnotationConfigTable table) {
        if (fieldNames.length == 0) {
            return table.columns();
        }
        ArrayList allColumns = new ArrayList();
        Collections.addAll(allColumns, table.columns());
        for (String fieldName : fieldNames) {
            allColumns.remove(table.getColumn(fieldName));
        }
        return (AnnotationConfigColumn[])allColumns.toArray(AnnotationConfigColumn[]::new);
    }

    private static AnnotationConfigColumn[] filterByFieldValueIsNull(Object entity, boolean globalIgnoreNull, Map<String, Boolean> ignoreNulls, AnnotationConfigColumn ... columns) {
        if (entity == null && globalIgnoreNull && ignoreNulls.isEmpty()) {
            return new AnnotationConfigColumn[0];
        }
        if (!globalIgnoreNull && ignoreNulls.isEmpty()) {
            return columns;
        }
        ArrayList<AnnotationConfigColumn> result = new ArrayList<AnnotationConfigColumn>();
        for (AnnotationConfigColumn column : columns) {
            Object value;
            String fieldName = column.javaField().name();
            Boolean ignoreNull = ignoreNulls.getOrDefault(fieldName, globalIgnoreNull);
            Object object = value = entity != null ? column.javaFieldValue(entity) : null;
            if (ignoreNull.booleanValue() && value == null) continue;
            result.add(column);
        }
        return (AnnotationConfigColumn[])result.toArray(AnnotationConfigColumn[]::new);
    }

    public static AnnotationConfigColumn[] filterByFieldExpressions(Map<String, String> fieldExpressions, AnnotationConfigTable table, AnnotationConfigColumn ... columns) {
        if (fieldExpressions.isEmpty()) {
            return columns;
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, columns);
        for (String fieldName : fieldExpressions.keySet()) {
            result.remove(table.getColumn(fieldName));
        }
        return (AnnotationConfigColumn[])result.toArray(AnnotationConfigColumn[]::new);
    }

    public static Object[] extractValues(AnnotationConfigColumn[] column, Object entity) {
        Object[] result = new Object[column.length];
        if (entity == null) {
            return result;
        }
        for (int i = 0; i < column.length; ++i) {
            result[i] = column[i].javaFieldValue(entity);
        }
        return result;
    }
}

