/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCGroupByParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLBuilder;
import java.util.Map;

public class SelectSQLBuilder {
    private final AnnotationConfigTable table;
    private final Dialect dialect;
    private final JDBCWhereParser whereParser;
    private final JDBCGroupByParser groupByParser;
    private final JDBCOrderByParser orderByParser;

    public SelectSQLBuilder(AnnotationConfigTable table, Dialect dialect, JDBCWhereParser whereParser, JDBCGroupByParser groupByParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.whereParser = whereParser;
        this.groupByParser = groupByParser;
        this.orderByParser = orderByParser;
    }

    public static String[] createVirtualSelectColumns(FieldPolicy fieldPolicy, Dialect dialect) {
        Map fieldExpressions = fieldPolicy.expressions();
        String[] virtualSelectColumns = new String[fieldExpressions.size()];
        int i = 0;
        for (Map.Entry fieldExpression : fieldExpressions.entrySet()) {
            String fieldName = (String)fieldExpression.getKey();
            String expression = (String)fieldExpression.getValue();
            virtualSelectColumns[i] = expression + " AS " + dialect.quoteIdentifier(fieldName);
            ++i;
        }
        return virtualSelectColumns;
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy) {
        Object[] selectColumns = SQLBuilderHelper.filterByFieldPolicy(fieldPolicy, this.table);
        String[] virtualSelectColumns = SelectSQLBuilder.createVirtualSelectColumns(fieldPolicy, this.dialect);
        Object[] finalSelectColumns = ArrayUtils.tryConcatAny((Object[])selectColumns, (Object[])virtualSelectColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        String sql = SQLBuilder.Select((Object[])finalSelectColumns).From((Object)this.table).Where(whereClause.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.getOffset(), query.getLimit()).GetSQL(this.dialect);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public SQL buildGetSQL(Query query, FieldPolicy fieldPolicy) {
        Object[] selectColumns = SQLBuilderHelper.filterByFieldPolicy(fieldPolicy, this.table);
        String[] virtualSelectColumns = SelectSQLBuilder.createVirtualSelectColumns(fieldPolicy, this.dialect);
        Object[] finalSelectColumns = ArrayUtils.tryConcatAny((Object[])selectColumns, (Object[])virtualSelectColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] groupByColumns = this.groupByParser.parse(query.getGroupBy());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        String sql = SQLBuilder.Select((Object[])finalSelectColumns).From((Object)this.table).Where(whereClause.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(null, Long.valueOf(1L)).GetSQL(this.dialect);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public SQL buildGetSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        SQL sql0 = this.buildGetSQL(query, fieldPolicy);
        String sql = SQLBuilder.Select((Object[])new Object[]{"*"}).From((Object)("(" + sql0.sql() + ")")).GetSQL(this.dialect);
        return SQL.sql((String)(sql + " AS " + this.table.name() + "_" + RandomUtils.randomString((int)6)), (Object[])sql0.params());
    }

    public SQL buildSelectSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        SQL sql0 = this.buildSelectSQL(query, fieldPolicy);
        String sql = SQLBuilder.Select((Object[])new Object[]{"*"}).From((Object)("(" + sql0.sql() + ")")).GetSQL(this.dialect);
        return SQL.sql((String)(sql + " AS " + this.table.name() + "_" + RandomUtils.randomString((int)6)), (Object[])sql0.params());
    }
}

