/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLBuilder;
import java.util.Map;

public class UpdateSQLBuilder {
    private final AnnotationConfigTable table;
    private final Dialect dialect;
    private final JDBCColumnNameParser columnNameParser;
    private final JDBCWhereParser whereParser;
    private final JDBCOrderByParser orderByParser;

    public UpdateSQLBuilder(AnnotationConfigTable table, Dialect dialect, JDBCColumnNameParser columnNameParser, JDBCWhereParser whereParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.columnNameParser = columnNameParser;
        this.whereParser = whereParser;
        this.orderByParser = orderByParser;
    }

    public static String[] createUpdateSetClauses(Column[] columns, Dialect dialect) {
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = dialect.quoteIdentifier(columns[i].name()) + " = ?";
        }
        return result;
    }

    public static String[] createUpdateSetExpressionsClauses(FieldPolicy fieldPolicy, JDBCColumnNameParser columnNameParser) {
        Map fieldExpressions = fieldPolicy.expressions();
        String[] result = new String[fieldExpressions.size()];
        int i = 0;
        for (Map.Entry entry : fieldExpressions.entrySet()) {
            String fieldName = (String)entry.getKey();
            String expression = (String)entry.getValue();
            result[i] = columnNameParser.parseColumnName(fieldName, false) + " = " + expression;
            ++i;
        }
        return result;
    }

    public SQL buildUpdateSQL(Object entity, FieldPolicy updateFilter, Query query) {
        if (query.getWhere().length == 0) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        AnnotationConfigColumn[] updateSetColumns = SQLBuilderHelper.filterByFieldPolicy(updateFilter, this.table, entity);
        Object[] updateSetClauses = UpdateSQLBuilder.createUpdateSetClauses((Column[])updateSetColumns, this.dialect);
        Object[] updateSetExpressionsColumns = UpdateSQLBuilder.createUpdateSetExpressionsClauses(updateFilter, this.columnNameParser);
        String[] finalUpdateSetClauses = (String[])ArrayUtils.tryConcat((Object[])updateSetClauses, (Object[])updateSetExpressionsColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBy());
        String sql = SQLBuilder.Update((Object)this.table).Set(finalUpdateSetClauses).Where(whereClause.whereClause()).OrderBy(orderByClauses).Limit(null, query.getLimit()).GetSQL(this.dialect);
        Object[] entityParams = SQLBuilderHelper.extractValues(updateSetColumns, entity);
        Object[] finalParams = ArrayUtils.tryConcat((Object[])entityParams, (Object[])whereClause.params());
        return SQL.sql((String)sql, (Object[])finalParams);
    }
}

