/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import cool.scx.common.util.StringUtils;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Where;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;

public final class JDBCColumnNameParser {
    private final Table tableInfo;
    private final Dialect dialect;

    public JDBCColumnNameParser(Table tableInfo, Dialect dialect) {
        this.tableInfo = tableInfo;
        this.dialect = dialect;
    }

    public static ColumnNameAndFieldPath splitIntoColumnNameAndFieldPath(String name) {
        char[] charArray = name.toCharArray();
        int index = charArray.length;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '.' && c != '[') continue;
            index = i;
            break;
        }
        String columnName = name.substring(0, index);
        String fieldPath = name.substring(index);
        return new ColumnNameAndFieldPath(columnName, fieldPath);
    }

    public String parseColumnName(Where w) {
        return this.parseColumnName(w.name(), w.info().useJsonExtract(), w.info().useOriginalName());
    }

    public String parseColumnName(GroupBy g) {
        return this.parseColumnName(g.name(), g.info().useJsonExtract(), g.info().useOriginalName());
    }

    public String parseColumnName(OrderBy o) {
        return this.parseColumnName(o.name(), o.info().useJsonExtract(), o.info().useOriginalName());
    }

    public String parseColumnName(String name, boolean useJsonExtract, boolean useOriginalName) {
        if (useJsonExtract) {
            ColumnNameAndFieldPath c = JDBCColumnNameParser.splitIntoColumnNameAndFieldPath(name);
            if (StringUtils.notBlank((String)c.columnName()) && StringUtils.notBlank((String)c.fieldPath())) {
                String jsonQueryColumnName = this.parseColumnName(c.columnName(), useOriginalName);
                return jsonQueryColumnName + " -> '$" + c.fieldPath() + "'";
            }
            throw new IllegalArgumentException("\u4f7f\u7528 USE_JSON_EXTRACT \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
        }
        return this.parseColumnName(name, useOriginalName);
    }

    public String parseColumnName(String name, boolean useOriginalName) {
        if (useOriginalName) {
            return this.dialect.quoteIdentifier(name);
        }
        Column column = this.tableInfo.getColumn(name);
        if (column == null) {
            throw new IllegalArgumentException("\u5728 Table : " + this.tableInfo.name() + " \u4e2d , \u672a\u627e\u5230\u5bf9\u5e94 name \u4e3a : " + name + " \u7684\u5217 !!!");
        }
        return this.dialect.quoteIdentifier(column.name());
    }

    public record ColumnNameAndFieldPath(String columnName, String fieldPath) {
    }
}

