/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.exception.WrongWhereParamTypeException;
import cool.scx.data.query.exception.WrongWhereTypeParamSizeException;
import cool.scx.data.query.parser.WhereParser;
import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class JDBCWhereParser
extends WhereParser {
    private final JDBCColumnNameParser columnNameParser;

    public JDBCWhereParser(JDBCColumnNameParser columnNameParser) {
        this.columnNameParser = columnNameParser;
    }

    public WhereClause parseIsNull(Where w) {
        String columnName = this.columnNameParser.parseColumnName(w);
        Object[] whereParams = new Object[]{};
        String whereClause = columnName + " " + this.getWhereKeyWord(w.whereType());
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseEqual(Where w) {
        Object[] whereParams;
        Object v1;
        if (w.value1() == null) {
            if (w.info().skipIfNull()) {
                return new WhereClause("", new Object[0]);
            }
            throw new WrongWhereTypeParamSizeException(w.name(), w.whereType(), 1);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            whereParams = new Object[]{w.value1()};
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(w.whereType()) + " " + (String)v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseLike(Where w) {
        Object[] whereParams;
        Object v1;
        if (w.value1() == null) {
            if (w.info().skipIfNull()) {
                return new WhereClause("", new Object[0]);
            }
            throw new WrongWhereTypeParamSizeException(w.name(), w.whereType(), 1);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            whereParams = new Object[]{w.value1()};
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(w.whereType()) + " CONCAT('%'," + (String)v1 + ",'%')";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseIn(Where w) {
        Object[] whereParams;
        String v1;
        if (w.value1() == null) {
            if (w.info().skipIfNull()) {
                return new WhereClause("", new Object[0]);
            }
            throw new WrongWhereTypeParamSizeException(w.name(), w.whereType(), 1);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            Object[] v = new Object[]{};
            try {
                v = ArrayUtils.toObjectArray((Object)w.value1());
            }
            catch (Exception e) {
                throw new WrongWhereParamTypeException(w.name(), w.whereType(), "\u6570\u7ec4");
            }
            whereParams = Arrays.stream(v).filter(Objects::nonNull).distinct().toArray();
            if (whereParams.length == 0) {
                if (w.info().skipIfEmptyList()) {
                    return new WhereClause("", new Object[0]);
                }
                throw new ValidParamListIsEmptyException(w.name(), w.whereType());
            }
            v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(w.whereType()) + " " + v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseBetween(Where w) {
        Object v2;
        Object v1;
        SQL a;
        if (w.value1() == null || w.value2() == null) {
            if (w.info().skipIfNull()) {
                return new WhereClause("", new Object[0]);
            }
            throw new WrongWhereTypeParamSizeException(w.name(), w.whereType(), 2);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        ArrayList<Object> whereParams = new ArrayList<Object>();
        Object object = w.value1();
        if (object instanceof SQL) {
            a = (SQL)object;
            v1 = "(" + a.sql() + ")";
            Collections.addAll(whereParams, a.params());
        } else {
            v1 = "?";
            whereParams.add(w.value1());
        }
        object = w.value2();
        if (object instanceof SQL) {
            a = (SQL)object;
            v2 = "(" + a.sql() + ")";
            Collections.addAll(whereParams, a.params());
        } else {
            v2 = "?";
            whereParams.add(w.value2());
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(w.whereType()) + " " + (String)v1 + " AND " + (String)v2;
        return new WhereClause(whereClause, whereParams.toArray());
    }

    public WhereClause parseJsonContains(Where w) {
        Object[] whereParams;
        Object v1;
        if (w.value1() == null) {
            if (w.info().skipIfNull()) {
                return new WhereClause("", new Object[0]);
            }
            throw new WrongWhereTypeParamSizeException(w.name(), w.whereType(), 1);
        }
        JDBCColumnNameParser.ColumnNameAndFieldPath c = JDBCColumnNameParser.splitIntoColumnNameAndFieldPath(w.name());
        String columnName = this.columnNameParser.parseColumnName(c.columnName(), w.info().useOriginalName());
        if (StringUtils.isBlank((String)c.columnName())) {
            throw new IllegalArgumentException("\u4f7f\u7528 " + String.valueOf(w.whereType()) + " \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + w.name());
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            if (w.info().useOriginalValue()) {
                whereParams = new Object[]{w.value1()};
            } else {
                try {
                    whereParams = new Object[]{ObjectUtils.toJson((Object)w.value1(), (ObjectUtils.Options)new ObjectUtils.Options().setIgnoreJsonIgnore(true).setIgnoreNullValue(true))};
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("\u4f7f\u7528 " + String.valueOf(w.whereType()) + " \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + w.name(), e);
                }
            }
        }
        String whereClause = this.getWhereKeyWord(w.whereType()) + "(" + columnName;
        whereClause = StringUtils.notBlank((String)c.fieldPath()) ? whereClause + ", " + (String)v1 + ", '$" + c.fieldPath() + "')" : whereClause + ", " + (String)v1 + ")";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parse(Object obj) {
        if (obj instanceof SQL) {
            SQL sql = (SQL)obj;
            return this.parseSQL(sql);
        }
        return super.parse(obj);
    }

    private WhereClause parseSQL(SQL sql) {
        return new WhereClause("(" + sql.sql() + ")", sql.params());
    }
}

