/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.MysqlType;
import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.dialect.DDLBuilder;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.mysql.MySQLDialectHelper;
import cool.scx.jdbc.standard.StandardDataType;
import java.util.ArrayList;
import java.util.List;

public class MySQLDDLBuilder
implements DDLBuilder {
    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(column.notNull() || column.primary() ? "NOT NULL" : "NULL");
        if (column.autoIncrement()) {
            list.add("AUTO_INCREMENT");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        if (StringUtils.notBlank((String)column.onUpdate())) {
            list.add("ON UPDATE " + column.onUpdate());
        }
        return list;
    }

    public String getDataTypeNameByStandardDataType(StandardDataType dataType) {
        MysqlType mysqlType = MySQLDialectHelper.standardDataTypeToDialectDataType(dataType);
        return mysqlType.getName();
    }

    public List<String> getTableConstraint(Table table) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : table.columns()) {
            String name = column.name();
            if (column.primary()) {
                list.add("PRIMARY KEY (`" + name + "`)");
            }
            if (column.unique()) {
                list.add("UNIQUE KEY `unique_" + name + "`(`" + name + "`)");
            }
            if (!column.index()) continue;
            list.add("KEY `index_" + name + "`(`" + name + "`)");
        }
        return list;
    }

    public String defaultDateType() {
        return "VARCHAR(128)";
    }
}

