/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.MysqlType;
import cool.scx.jdbc.standard.StandardDataType;

public final class MySQLDialectHelper {
    public static StandardDataType dialectDataTypeToStandardDataType(String dialectDataType) {
        if ("VARCHAR".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.VARCHAR;
        }
        if ("BIT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BOOLEAN;
        }
        if ("INT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DATETIME;
        }
        if ("BIGINT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BIGINT;
        }
        if ("BIGINT UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BIGINT;
        }
        if ("TEXT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.TEXT;
        }
        if ("DATETIME".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DATETIME;
        }
        if ("JSON".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.JSON;
        }
        if ("DATE".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DATE;
        }
        if ("INT UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.INT;
        }
        if ("LONGTEXT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.LONGTEXT;
        }
        if ("ENUM".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.VARCHAR;
        }
        if ("MEDIUMTEXT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.TEXT;
        }
        if ("SET".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.VARCHAR;
        }
        if ("TIMESTAMP".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DATETIME;
        }
        if ("CHAR".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.VARCHAR;
        }
        if ("BINARY".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BINARY;
        }
        if ("FLOAT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.FLOAT;
        }
        if ("VARBINARY".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BINARY;
        }
        if ("DECIMAL".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DECIMAL;
        }
        if ("BLOB".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BINARY;
        }
        if ("DOUBLE".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DOUBLE;
        }
        if ("TINYINT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.TINYINT;
        }
        if ("MEDIUMBLOB".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BINARY;
        }
        if ("SMALLINT UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.SMALLINT;
        }
        if ("TINYINT UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.TINYINT;
        }
        if ("TIME".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.TIME;
        }
        if ("SMALLINT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.SMALLINT;
        }
        if ("MEDIUMINT UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.INT;
        }
        if ("LONGBLOB".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.BINARY;
        }
        if ("DECIMAL UNSIGNED".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.DECIMAL;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u65b9\u8a00\u6570\u636e\u7c7b\u578b : " + dialectDataType);
    }

    public static MysqlType standardDataTypeToDialectDataType(StandardDataType standardDataType) {
        return switch (standardDataType) {
            default -> throw new MatchException(null, null);
            case StandardDataType.TINYINT -> MysqlType.TINYINT;
            case StandardDataType.SMALLINT -> MysqlType.SMALLINT;
            case StandardDataType.INT -> MysqlType.INT;
            case StandardDataType.BIGINT -> MysqlType.BIGINT;
            case StandardDataType.FLOAT -> MysqlType.FLOAT;
            case StandardDataType.DOUBLE -> MysqlType.DOUBLE;
            case StandardDataType.BOOLEAN -> MysqlType.BOOLEAN;
            case StandardDataType.DECIMAL -> MysqlType.DECIMAL;
            case StandardDataType.DATE -> MysqlType.DATE;
            case StandardDataType.TIME -> MysqlType.TIME;
            case StandardDataType.DATETIME -> MysqlType.DATETIME;
            case StandardDataType.VARCHAR -> MysqlType.VARCHAR;
            case StandardDataType.TEXT -> MysqlType.TEXT;
            case StandardDataType.LONGTEXT -> MysqlType.LONGTEXT;
            case StandardDataType.BINARY -> MysqlType.BINARY;
            case StandardDataType.JSON -> MysqlType.JSON;
        };
    }
}

