/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.MysqlType;
import cool.scx.jdbc.standard.StandardDataType;
import java.util.Map;
import java.util.TreeMap;

public final class MySQLDialectHelper {
    private static final Map<String, StandardDataType> MAP = MySQLDialectHelper.initMAP();

    private static Map<String, StandardDataType> initMAP() {
        TreeMap<String, StandardDataType> map = new TreeMap<String, StandardDataType>(String.CASE_INSENSITIVE_ORDER);
        map.put("TINYINT", StandardDataType.TINYINT);
        map.put("TINYINT UNSIGNED", StandardDataType.TINYINT);
        map.put("SMALLINT", StandardDataType.SMALLINT);
        map.put("SMALLINT UNSIGNED", StandardDataType.SMALLINT);
        map.put("MEDIUMINT UNSIGNED", StandardDataType.INT);
        map.put("INT", StandardDataType.INT);
        map.put("INT UNSIGNED", StandardDataType.INT);
        map.put("BIGINT", StandardDataType.BIGINT);
        map.put("BIGINT UNSIGNED", StandardDataType.BIGINT);
        map.put("FLOAT", StandardDataType.FLOAT);
        map.put("DOUBLE", StandardDataType.DOUBLE);
        map.put("DECIMAL", StandardDataType.DECIMAL);
        map.put("DECIMAL UNSIGNED", StandardDataType.DECIMAL);
        map.put("BIT", StandardDataType.BOOLEAN);
        map.put("TIME", StandardDataType.TIME);
        map.put("DATE", StandardDataType.DATE);
        map.put("DATETIME", StandardDataType.DATETIME);
        map.put("TIMESTAMP", StandardDataType.DATETIME);
        map.put("VARCHAR", StandardDataType.VARCHAR);
        map.put("CHAR", StandardDataType.VARCHAR);
        map.put("TEXT", StandardDataType.TEXT);
        map.put("MEDIUMTEXT", StandardDataType.LONGTEXT);
        map.put("LONGTEXT", StandardDataType.LONGTEXT);
        map.put("BLOB", StandardDataType.BLOB);
        map.put("MEDIUMBLOB", StandardDataType.LONGBLOB);
        map.put("LONGBLOB", StandardDataType.LONGBLOB);
        map.put("BINARY", StandardDataType.BLOB);
        map.put("VARBINARY", StandardDataType.BLOB);
        map.put("JSON", StandardDataType.JSON);
        map.put("ENUM", StandardDataType.VARCHAR);
        map.put("SET", StandardDataType.VARCHAR);
        return map;
    }

    public static StandardDataType dialectDataTypeToStandardDataType(String dialectDataType) {
        StandardDataType standardDataType = MAP.get(dialectDataType);
        if (standardDataType == null) {
            throw new IllegalArgumentException("\u672a\u77e5\u65b9\u8a00\u6570\u636e\u7c7b\u578b : " + dialectDataType);
        }
        return standardDataType;
    }

    public static MysqlType standardDataTypeToDialectDataType(StandardDataType standardDataType) {
        return switch (standardDataType) {
            default -> throw new MatchException(null, null);
            case StandardDataType.TINYINT -> MysqlType.TINYINT;
            case StandardDataType.SMALLINT -> MysqlType.SMALLINT;
            case StandardDataType.INT -> MysqlType.INT;
            case StandardDataType.BIGINT -> MysqlType.BIGINT;
            case StandardDataType.FLOAT -> MysqlType.FLOAT;
            case StandardDataType.DOUBLE -> MysqlType.DOUBLE;
            case StandardDataType.BOOLEAN -> MysqlType.BOOLEAN;
            case StandardDataType.DECIMAL -> MysqlType.DECIMAL;
            case StandardDataType.DATE -> MysqlType.DATE;
            case StandardDataType.TIME -> MysqlType.TIME;
            case StandardDataType.DATETIME -> MysqlType.DATETIME;
            case StandardDataType.VARCHAR -> MysqlType.VARCHAR;
            case StandardDataType.TEXT -> MysqlType.TEXT;
            case StandardDataType.LONGTEXT -> MysqlType.LONGTEXT;
            case StandardDataType.BLOB -> MysqlType.BLOB;
            case StandardDataType.LONGBLOB -> MysqlType.LONGBLOB;
            case StandardDataType.JSON -> MysqlType.JSON;
        };
    }
}

