/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.PreparedQuery;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.Driver;
import com.mysql.cj.jdbc.MysqlDataSource;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import cool.scx.jdbc.JDBCType;
import cool.scx.jdbc.dialect.DDLBuilder;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mysql.MySQLDDLBuilder;
import cool.scx.jdbc.mysql.MySQLDialectHelper;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class MySQLDialect
extends Dialect {
    private static final NonRegisteringDriver DRIVER = MySQLDialect.initDRIVER();
    private static final MySQLDDLBuilder MYSQL_DDL_BUILDER = new MySQLDDLBuilder();

    private static NonRegisteringDriver initDRIVER() {
        try {
            return new NonRegisteringDriver();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(String url) {
        try {
            return DRIVER.acceptsURL(url);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof MysqlDataSource || dataSource.isWrapperFor(MysqlDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(java.sql.Driver driver) {
        return driver instanceof Driver;
    }

    public String getFinalSQL(Statement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    public DDLBuilder ddlBuilder() {
        return MYSQL_DDL_BUILDER;
    }

    public DataSource createDataSource(String url, String username, String password, String[] parameters) {
        MysqlDataSource mysqlDataSource = new MysqlDataSource();
        mysqlDataSource.setUrl(url);
        mysqlDataSource.setUser(username);
        mysqlDataSource.setPassword(password);
        for (String parameter : parameters) {
            String[] p = parameter.split("=");
            if (p.length != 2) continue;
            RuntimeProperty property = mysqlDataSource.getProperty(p[0]);
            property.setValue(property.getPropertyDefinition().parseObject(p[1], null));
        }
        return mysqlDataSource;
    }

    public PreparedStatement beforeExecuteQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setFetchSize(Integer.MIN_VALUE);
        return preparedStatement;
    }

    public JDBCType dialectDataTypeToJDBCType(String dialectDataType) {
        return MySQLDialectHelper.dialectDataTypeToJDBCType(dialectDataType);
    }

    public String jdbcTypeToDialectDataType(JDBCType jdbcType) {
        return MySQLDialectHelper.jdbcTypeToDialectDataType(jdbcType).getName();
    }
}

