/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.MysqlType;
import cool.scx.jdbc.JDBCType;
import java.util.Map;
import java.util.TreeMap;

public final class MySQLDialectHelper {
    private static final Map<String, JDBCType> MAP = MySQLDialectHelper.initMAP();

    private static Map<String, JDBCType> initMAP() {
        TreeMap<String, JDBCType> map = new TreeMap<String, JDBCType>(String.CASE_INSENSITIVE_ORDER);
        map.put("TINYINT", JDBCType.TINYINT);
        map.put("TINYINT UNSIGNED", JDBCType.TINYINT);
        map.put("SMALLINT", JDBCType.SMALLINT);
        map.put("SMALLINT UNSIGNED", JDBCType.SMALLINT);
        map.put("MEDIUMINT UNSIGNED", JDBCType.INT);
        map.put("INT", JDBCType.INT);
        map.put("INT UNSIGNED", JDBCType.INT);
        map.put("BIGINT", JDBCType.BIGINT);
        map.put("BIGINT UNSIGNED", JDBCType.BIGINT);
        map.put("FLOAT", JDBCType.FLOAT);
        map.put("DOUBLE", JDBCType.DOUBLE);
        map.put("DECIMAL", JDBCType.DECIMAL);
        map.put("DECIMAL UNSIGNED", JDBCType.DECIMAL);
        map.put("BIT", JDBCType.BOOLEAN);
        map.put("TIME", JDBCType.TIME);
        map.put("DATE", JDBCType.DATE);
        map.put("DATETIME", JDBCType.DATETIME);
        map.put("TIMESTAMP", JDBCType.DATETIME);
        map.put("VARCHAR", JDBCType.VARCHAR);
        map.put("CHAR", JDBCType.VARCHAR);
        map.put("TEXT", JDBCType.TEXT);
        map.put("MEDIUMTEXT", JDBCType.LONGTEXT);
        map.put("LONGTEXT", JDBCType.LONGTEXT);
        map.put("BLOB", JDBCType.BLOB);
        map.put("MEDIUMBLOB", JDBCType.LONGBLOB);
        map.put("LONGBLOB", JDBCType.LONGBLOB);
        map.put("BINARY", JDBCType.BLOB);
        map.put("VARBINARY", JDBCType.BLOB);
        map.put("JSON", JDBCType.JSON);
        map.put("ENUM", JDBCType.VARCHAR);
        map.put("SET", JDBCType.VARCHAR);
        return map;
    }

    public static JDBCType dialectDataTypeToJDBCType(String dialectDataType) {
        JDBCType standardDataType = MAP.get(dialectDataType);
        if (standardDataType == null) {
            throw new IllegalArgumentException("\u672a\u77e5\u65b9\u8a00\u6570\u636e\u7c7b\u578b : " + dialectDataType);
        }
        return standardDataType;
    }

    public static MysqlType jdbcTypeToDialectDataType(JDBCType jdbcType) {
        return switch (jdbcType) {
            default -> throw new MatchException(null, null);
            case JDBCType.TINYINT -> MysqlType.TINYINT;
            case JDBCType.SMALLINT -> MysqlType.SMALLINT;
            case JDBCType.INT -> MysqlType.INT;
            case JDBCType.BIGINT -> MysqlType.BIGINT;
            case JDBCType.FLOAT -> MysqlType.FLOAT;
            case JDBCType.DOUBLE -> MysqlType.DOUBLE;
            case JDBCType.BOOLEAN -> MysqlType.BOOLEAN;
            case JDBCType.DECIMAL -> MysqlType.DECIMAL;
            case JDBCType.DATE -> MysqlType.DATE;
            case JDBCType.TIME -> MysqlType.TIME;
            case JDBCType.DATETIME -> MysqlType.DATETIME;
            case JDBCType.VARCHAR -> MysqlType.VARCHAR;
            case JDBCType.TEXT -> MysqlType.TEXT;
            case JDBCType.LONGTEXT -> MysqlType.LONGTEXT;
            case JDBCType.BLOB -> MysqlType.BLOB;
            case JDBCType.LONGBLOB -> MysqlType.LONGBLOB;
            case JDBCType.JSON -> MysqlType.JSON;
        };
    }
}

