/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sqlite;

import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.dialect.DDLBuilder;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.sqlite.SQLiteDialectHelper;
import cool.scx.jdbc.standard.StandardDataType;
import java.util.ArrayList;
import java.util.List;

public class SQLiteDDLBuilder
implements DDLBuilder {
    public String getDataTypeNameByStandardDataType(StandardDataType dataType) {
        return SQLiteDialectHelper.standardDataTypeToDialectDataType(dataType);
    }

    public String getDataTypeDefinitionByName(String dataType, Integer length) {
        return dataType;
    }

    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        if (column.primary() && column.autoIncrement()) {
            list.add("PRIMARY KEY AUTOINCREMENT");
        }
        list.add(column.notNull() || column.primary() ? "NOT NULL" : "NULL");
        if (column.unique()) {
            list.add("UNIQUE");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        return list;
    }
}

