/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sqlite;

import cool.scx.jdbc.JDBCHelper;
import cool.scx.jdbc.dialect.DDLBuilder;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sqlite.SQLiteDDLBuilder;
import cool.scx.jdbc.sqlite.SQLiteDialectHelper;
import cool.scx.jdbc.sqlite.type_handler.SQLiteLocalDateTimeTypeHandler;
import cool.scx.jdbc.standard.StandardDataType;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import javax.sql.DataSource;
import org.sqlite.JDBC;
import org.sqlite.SQLiteDataSource;
import org.sqlite.core.CorePreparedStatement;
import org.sqlite.core.CoreStatement;
import org.sqlite.jdbc4.JDBC4PreparedStatement;

public class SQLiteDialect
extends Dialect {
    public static final System.Logger logger = System.getLogger(SQLiteDialect.class.getName());
    static final Field CoreStatement_sql = SQLiteDialect.initCoreStatement_sql();
    static final Field CoreStatement_batch = SQLiteDialect.initCoreStatement_batch();
    static final Field CorePreparedStatement_batchQueryCount = SQLiteDialect.initCorePreparedStatement_batchQueryCount();
    private static final SQLiteDDLBuilder SQLite_DDL_BUILDER = new SQLiteDDLBuilder();
    private static final JDBC DRIVER = SQLiteDialect.initDRIVER();

    public SQLiteDialect() {
        this.typeHandlerSelector.registerTypeHandler(LocalDateTime.class, (TypeHandler)new SQLiteLocalDateTimeTypeHandler());
    }

    private static Field initCoreStatement_sql() {
        try {
            Field f = CoreStatement.class.getDeclaredField("sql");
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field initCoreStatement_batch() {
        try {
            Field f = CoreStatement.class.getDeclaredField("batch");
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field initCorePreparedStatement_batchQueryCount() {
        try {
            Field f = CorePreparedStatement.class.getDeclaredField("batchQueryCount");
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static JDBC initDRIVER() {
        try {
            return new JDBC();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(String url) {
        return DRIVER.acceptsURL(url);
    }

    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof SQLiteDataSource || dataSource.isWrapperFor(SQLiteDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(Driver driver) {
        return driver instanceof JDBC;
    }

    public String getFinalSQL(Statement statement) {
        int batchQueryCount;
        Object[] batch;
        String sql;
        CorePreparedStatement corePreparedStatement;
        try {
            corePreparedStatement = (CorePreparedStatement)statement.unwrap(JDBC4PreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            sql = (String)CoreStatement_sql.get(corePreparedStatement);
            batch = (Object[])CoreStatement_batch.get(corePreparedStatement);
            batchQueryCount = (Integer)CorePreparedStatement_batchQueryCount.get(corePreparedStatement);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        String finalSQL = JDBCHelper.getSqlWithValues((String)sql, (Object[])batch);
        return batchQueryCount > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchQueryCount - 1) + " \u9879" : finalSQL;
    }

    public DDLBuilder ddlBuilder() {
        return SQLite_DDL_BUILDER;
    }

    public DataSource createDataSource(String url, String username, String password, String[] parameters) {
        SQLiteDataSource sqLiteDataSource = new SQLiteDataSource();
        sqLiteDataSource.setUrl(url);
        return sqLiteDataSource;
    }

    public StandardDataType dialectDataTypeToStandardDataType(String dialectDataType) {
        return SQLiteDialectHelper.dialectDataTypeToStandardDataType(dialectDataType);
    }

    public String standardDataTypeToDialectDataType(StandardDataType standardDataType) {
        return SQLiteDialectHelper.standardDataTypeToDialectDataType(standardDataType);
    }
}

