/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sqlite;

import cool.scx.jdbc.standard.StandardDataType;

public class SQLiteDialectHelper {
    public static StandardDataType dialectDataTypeToStandardDataType(String dialectDataType) {
        if ("TEXT".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.VARCHAR;
        }
        if ("INTEGER".equalsIgnoreCase(dialectDataType)) {
            return StandardDataType.INT;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u65b9\u8a00\u6570\u636e\u7c7b\u578b : " + dialectDataType);
    }

    public static String standardDataTypeToDialectDataType(StandardDataType standardDataType) {
        return switch (standardDataType) {
            default -> throw new MatchException(null, null);
            case StandardDataType.TINYINT, StandardDataType.SMALLINT, StandardDataType.INT, StandardDataType.BIGINT, StandardDataType.BOOLEAN -> "INTEGER";
            case StandardDataType.FLOAT, StandardDataType.DOUBLE, StandardDataType.DECIMAL -> "REAL";
            case StandardDataType.DATE, StandardDataType.TIME, StandardDataType.DATETIME, StandardDataType.VARCHAR, StandardDataType.TEXT, StandardDataType.LONGTEXT, StandardDataType.JSON -> "TEXT";
            case StandardDataType.BLOB, StandardDataType.LONGBLOB -> "BLOB";
        };
    }
}

