package coop.intergal.ui.util;


import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.beans.factory.annotation.Value;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.function.SerializableComparator;

import coop.intergal.AppConst;
import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.utils.Broadcaster;
import coop.intergal.ui.utils.ProcessParams;
import coop.intergal.ui.views.DynamicDisplayForAskData;
import coop.intergal.ui.views.DynamicGridForPick;
import coop.intergal.ui.views.DynamicQryGridDisplay;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.ui.views.GeneratedUtil;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;

public class GenericClassForMethods {
	
	@Value("${app.const.package_views}")
	private String package_views;
	
	private DynamicDBean rowOfAskData;
	private DynamicDBean keepFirstParent;
	private DynamicQryGridDisplay dQGD;
	private JsonNode actualRowStep;
	private DynamicViewGrid actualGrid;
	private DynamicDBean actualRowOfInputData;
	private boolean errorInprocess = false;
	private Dialog dialogToAskData;
	public Object processButtonForNavigation(String idButton, DynamicDBean bean, Div divSubGrid, DynamicViewGrid grid) {
		return processButtonForNavigation(idButton, bean, divSubGrid, grid, null);
	}
	public Object processButtonForNavigation(String idButton, DynamicDBean bean, Div divSubGrid, DynamicViewGrid grid, String filter2) {
//		String titleOption = rowSubMenu.get("optionName").asText();
		int idxIdMenu = idButton.indexOf("@IDM");
		boolean isPopup = idButton.indexOf("@POP") > -1;
		String filterInButton = "";
		int idxFIB = idButton.indexOf("@FILTER");
		if (idxFIB > -1) {
			filterInButton = idButton.substring(idxFIB+7);
			if (filterInButton.indexOf("@") > -1) { // to avoid other params
				filterInButton = filterInButton.substring(0,filterInButton.indexOf("@"));
			}
			
		}
		if (idxIdMenu == -1)
		{
			DataService.get().showError("Id de menu sin indicar, se debe de especificar en el formato nombreopcion#IDMnumero");
			return null; 
		}
		try {
		String idMenu = idButton.substring(idxIdMenu+4);
		if (idMenu.indexOf("@") > -1) { // to avoid other params
			idMenu = idMenu.substring(0,idMenu.indexOf("@"));
		}
		
		String filter = "idMenu="+idMenu;
		JsonNode rowsList = JSonClient.get("menu",filter,false,AppConst.PRE_CONF_PARAM_METADATA,1+"");
		for (JsonNode rowSubMenu : rowsList)  
			{
			String layoutPage = null;
			if (rowSubMenu.get("layoutPage") == null)
				layoutPage = "PAGE_DYNAMIC_QGD";
			else
				layoutPage = rowSubMenu.get("layoutPage").asText();
			if (layoutPage == null || layoutPage.isEmpty() || layoutPage.equals("null") )
				layoutPage = AppConst.PAGE_DYNAMIC_QGD;
			else if (layoutPage.equals("PAGE_DYNAMIC_QGD"))
				layoutPage = AppConst.PAGE_DYNAMIC_QGD;
			else if (layoutPage.equals("PAGE_DYNAMIC_QG"))
				layoutPage = AppConst.PAGE_DYNAMIC_QG;
			else
				DataService.get().showError("valor invalido para layoutPage, debe de ser (PAGE_DYNAMIC_QG o PAGE_DYNAMIC_QGD");
			String urlBase = "../"+layoutPage;
			String hostName = InetAddress.getLocalHost().getHostName() ;
			if (hostName.indexOf(".local") == -1 && hostName.indexOf("FC-NB-MLOPEZ") == -1) // to diferent when is running in local (Maven) or in remote (tys.war -> tomcat)
				urlBase= "../tys"+AppConst.CURRENT_YEAR+"/"+layoutPage;
			String optionName = rowSubMenu.get("optionName").asText();	
			String resource = rowSubMenu.get("resource").asText();
			String queryFormClassName = rowSubMenu.get("queryFormClassName").asText();
			String displayFormClassName = rowSubMenu.get("displayFormClassName").asText();
			String layoutClassName = rowSubMenu.get("layout").asText();
			String filterForPopup = rowSubMenu.get("filterForPopup").asText();
//			String idMenu = rowSubMenu.get("idMenu").asText();
			if (queryFormClassName.startsWith("coop.intergal.ui.views") == false)
				queryFormClassName = package_views+queryFormClassName;
			if (displayFormClassName.startsWith("coop.intergal.ui.views") == false)
				displayFormClassName = package_views+displayFormClassName;
			if (filterInButton.length() > 0 && filterForPopup != null && filterForPopup.equals("null") == false && filterForPopup.length() > 0)
			{
				filterForPopup = filterForPopup + ";"+ filterInButton;
			}
			else if (filterInButton.length() > 0)
			{
				filterForPopup = filterInButton;
			}
			
			
//		titleOption = titleOption.replace(" ", "%20");
			if (isPopup)
			{
//				String filterForNavigation = "row.subgrid.CLAVEARTICULO=rowtarget.CLAVE_ARTICULO";
				if ( layoutClassName.indexOf("DynamicViewGrid") > -1 || layoutClassName.indexOf("DynamicQryGridDisplay") > -1)  // when is a grid list is send the origin row to filter the list in the target 
				{
					DynamicDBean sourceRow = getRowSelected(divSubGrid, grid, bean);
					if (sourceRow != null )
						showDialog(sourceRow, resource, layoutClassName, displayFormClassName, grid, filterForPopup, null );
					else
						{
			//			DataService.get().showError("Debe seleccionar un registro");
						return null;
						}
				}
				else // // when is a Display is send the target row to be show as target
				{
				DynamicDBean beanToShow = getBeanToShow(bean, filterForPopup, resource, divSubGrid, grid);
				if (beanToShow != null )
					showDialog(beanToShow, resource, layoutClassName, displayFormClassName, grid, filterForPopup, null );
				}
			}	
			else // is new tab open, the filter must be made with " for values
				{
				if (filterInButton.length() > 0)
				{
					if (bean == null) // comes from a grid
					{
						bean = grid.getSelectedRow();
						if (bean == null)
						{
							DataService.get().showError("Debe seleccionar un registro");
							return null;
						}
					}
					filterInButton = ProcessParams.componFilterFromParams(filterInButton, bean);
//					filterInButton = filterInButton.replace("'","\"");
				}
					
				if((filter2 != null && filter2.length() > 0 && filter2 != null && filter2.equals("null") == false && filter2.length() > 0)
					&&
					(filterInButton != null && filterInButton.length() > 0 && filterInButton != null && filterInButton.equals("null") == false && filterInButton.length() > 0))
				{
					filter2 = filter2 + "%20AND%20"+ filterInButton;
				}
				else if (filterInButton != null && filterInButton.length() > 0)
				{
					filter2 = filterInButton;
				}
				if (filter2 != null)
				{
					String url = urlBase+"?resourceName="+resource+"&queryFormClassName="+queryFormClassName+"&displayFormClassName="+displayFormClassName+"&title="+optionName+"&idMenu="+idMenu+"&filter="+filter2;
					UI.getCurrent().getPage().executeJs("window.open(\""+url+"\", \"_blank\");");
				}
				else
					UI.getCurrent().getPage().executeJs("window.open(\""+urlBase+"?resourceName="+resource+"&queryFormClassName="+queryFormClassName+"&displayFormClassName="+displayFormClassName+"&title="+optionName+"&idMenu="+idMenu+"\", \"_blank\");");
				}
			}
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
	}
	private DynamicDBean getBeanToShow(DynamicDBean bean2, String filterForNavigation, String resource, Div divSubGrid, DynamicViewGrid grid) {
		if (filterForNavigation.startsWith("row."))
		{				
			String filter = componFilterFromSubgridRowSelected(filterForNavigation, divSubGrid, grid, bean2);
			if (filter != null)
				{
				DynamicDBean rowtoShow = RestData.getOneRow(resource, filter, UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);					
				return rowtoShow;
				}
		}
		return null;
	}

	private String componFilterFromSubgridRowSelected(String filterForNavigation, Div divSubGrid, DynamicViewGrid grid, DynamicDBean bean2) { // @@ TODO prepare for multi filter
	
		return ProcessParams.componFilterFromParams(filterForNavigation,getRowSelected(divSubGrid, grid, bean2));

		
		
	}

	private DynamicDBean getRowSelected(Div divSubGrid, DynamicViewGrid dvGrid, DynamicDBean bean2) {
		if (bean2 != null) {
			return bean2;
		}
		if (dvGrid == null)
			dvGrid = (DynamicViewGrid) divSubGrid.getChildren().findFirst().get().getChildren().findFirst().get().getChildren().findFirst().get();
		Set<DynamicDBean> seletedItems = dvGrid.getGrid().getSelectedItems();
		if (seletedItems.isEmpty())
		{
			DataService.get().showError("Debe seleccionar un registro");
			return null;
		}
		return seletedItems.iterator().next();
	}
	private DynamicDBean showDialog(DynamicDBean bean2, String resource2, String layoutClassName, String displayFormClassName, DynamicViewGrid grid, String filterForPopup, DynamicDisplayForAskData dynamicDisplayForAskData) { 
		
		DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
		dataProvider.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		dataProvider.setResourceName(resource2);
//		dataProvider.setFilter(getFilter());

		
		dialogToAskData = grid.showBeaninPopup(bean2, resource2,layoutClassName, displayFormClassName, null, filterForPopup, dynamicDisplayForAskData );

//			dialogForPick = new Dialog();
//		dialogForPick.removeAll();
//		dialogForPick.setCloseOnOutsideClick(false);
//		dialogForPick.add(new Label(bean.getCol0()));
//		dialogForPick.open();
		
		
		
		return null;
	}

	public Object processButtonForProcess(String idButton, DynamicDBean bean, Div divSubGrid, DynamicViewGrid grid)
	{
		int idxIdProcess = idButton.indexOf("@IDP");
		if (idxIdProcess == -1)
		{
			DataService.get().showError("Id de proceso sin indicar, se debe de especificar en el formato nombreopcion#IDPnumero");
			return null; 
		}
		try {
			String idMProcess = idButton.substring(idxIdProcess+4);
			String filter = "idProcess="+idMProcess;
			JsonNode rowsList;
			rowsList = JSonClient.get("CR-Process",filter,false,AppConst.PRE_CONF_PARAM_METADATA,100+"");
			JsonNode rowProcess = rowsList.get(0);  
			System.out.println("GenericClassForMethods.processButtonForProcess() "+ rowProcess.get("name").asText());
			JsonNode rowsSteps = rowProcess.get("List-ProcessStep");
			JsonNode FirstStep = rowsSteps.get(0);
			processSteps(FirstStep, grid, bean); 
			
		} catch (Exception e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
		}

		return null; 
	}
	public Object proccesButtonForContinueProcess(String idButton, DynamicDBean bean, Div divSubGrid, DynamicViewGrid grid)
	{
		int idxStart = idButton.indexOf("@CPOption")+9;
		String idNextStep = null;
		if (idxStart > 8 )
			idNextStep = idButton.substring(idxStart);
		nextStepIfExist(actualRowStep, actualGrid, actualRowOfInputData, idNextStep);
		return null;
	}
	private void processSteps(JsonNode rowStep, DynamicViewGrid grid, DynamicDBean bean) {//(JsonNode rowStep, DynamicViewGrid grid, DynamicDBean rowPreviousStep) {
		System.out.println("GenericClassForMethods.processButtonForProcess() STEP "+ rowStep.get("name").asText());	
		String inputResourceForReadData = rowStep.get("inputResourceForReadData").asText().trim();
		String inputResourceForAskData = rowStep.get("inputResourceForAskData").asText().trim();
		DynamicDBean rowOfInputData = bean;
		String dialogClassLayout = rowStep.get("dialogClassLayout").asText();
		String dialogClassDisplayForm = rowStep.get("dialogClassDisplayForm").asText();
		String filterForShowResult = rowStep.get("filterForShowResult").asText();
		String idButtonForShowResult = rowStep.get("idButtonForShowResult").asText(); // format @POP (if popup) + @IDM<<idmenu>>
		String idMenuOpenUIToProcess = rowStep.get("idMenuOpenUIToProcess").asText();
		String conditionForProcess = rowStep.get("conditionForProcess").asText();
		
		/// **** CHECK CONDITION
		if ((conditionForProcess != null && conditionForProcess.equals("null") == false && conditionForProcess.isEmpty() == false) &&     
			!(idMenuOpenUIToProcess != null && idMenuOpenUIToProcess.equals("null") == false )) // idMenuOpenUIToProcess has is own process of conditions
		{
			DynamicDBean rowToGetData = null;
			if (conditionForProcess.startsWith("parentRow"))
			{
				
				if (grid != null && grid.getParentGrid() != null)
					rowToGetData = grid.getParentGrid().getSelectedRow();

			}
			else
			{
				Stream<DynamicDBean> rowsStream = ((DataProvider<DynamicDBean, String>) grid.getGrid().getDataProvider()).fetch(createQuery(grid.getGrid()));
				Iterator<DynamicDBean> rowsInput = rowsStream.iterator();
				rowToGetData = rowsInput.next();
				
			}

			if (isProcessable(rowToGetData, conditionForProcess))
			{
				nextStepIfExist(rowStep, grid, rowOfInputData, null);
			}
			else
			{
				int idxError = conditionForProcess.indexOf("#ERROR");
				if (idxError != -1)
	//				DataService.get().showError("condicion para processo ("+conditionForProcess +") sin especificar #ERROR");
	//			else
					DataService.get().showError(conditionForProcess.substring(idxError+6));
			}
		}	
		else
		{	
		
		// ***** SEND DATA TO OTHER FORM	
		if (idMenuOpenUIToProcess != null && idMenuOpenUIToProcess.equals("null") == false )  
		{
			dQGD = (DynamicQryGridDisplay) getOpenUI(idMenuOpenUIToProcess);  // @@TODO for now all the option are of the type DynamicQryGridDisplay, consider to add more types
			if (dQGD ==  null) 
			{
				DataService.get().showError("Formulario para recibir dato sin abrir");
			}
			else
			{
				System.out.println("GenericClassForMethods.processSteps() UI found!" + dQGD.getPageTitle());
				if (conditionForProcess != null && conditionForProcess.equals("null") == false && conditionForProcess.isEmpty() == false)
				{
					if (isProcessable(grid, conditionForProcess))
						nextStepIfExist(rowStep, grid, rowOfInputData,null);					
					else 
						errorInprocess = true;
				}
				else
					nextStepIfExist(rowStep, grid, rowOfInputData,null);
			}
				
		}
		/// **** SHOWS POPUP TO ASK DATA
		
		else if (inputResourceForAskData != null && inputResourceForAskData.equals("null") == false && inputResourceForAskData.isEmpty() == false  )   
		{
//			rowOfInputData = askInputData(inputResourceForAskData, grid, dialogClassLayout, dialogClassDisplayForm);
			askForDataAndContinue(dialogClassLayout, inputResourceForAskData, grid, dialogClassDisplayForm, rowStep, rowOfInputData);
			
		}
		else
		{
		/// **** SHOWS RESULT IN OTHER FORM	
			if (filterForShowResult != null && filterForShowResult.equals("null") == false && filterForShowResult.isEmpty() == false)
			{
				showResult(filterForShowResult,idButtonForShowResult);
				nextStepIfExist(rowStep, grid, rowOfInputData, null);
			}
		//// **** PROCESS OUPUT DATA	
			else
			{
				proccesDataInputOuput(rowStep, grid, dialogClassDisplayForm, rowOfInputData);//(rowPreviousStep,rowStep, grid, dialogClassDisplayForm, rowOfInputData);(rowPreviousStep,rowStep, grid, dialogClassDisplayForm, rowOfInputData);
				nextStepIfExist(rowStep, grid, rowOfInputData, null);
		}
		}
//		JsonNode rowsStepOuput = rowStep.get("List-ProcessStepOutput");
//		processInputOuput(grid, inputResourceForReadData, rowOfInputData, rowsStepOuput);
//		for (JsonNode rowStepOuput : rowsStepOuput) 
//			{
//			System.out.println("GenericClassForMethods.processButtonForProcess() STEP OUTPUT "+ rowStepOuput.get("resource").asText());
//			}
		}
		}
		
	private boolean isProcessable(DynamicViewGrid grid, String conditionForProcess) {
		int idxError = conditionForProcess.indexOf("#ERROR");
		if (idxError == -1)
			{
			DataService.get().showError("condicion para processo ("+conditionForProcess +") sin especificar #ERROR"); 
			return false;
			}
		StringTokenizer tokens = new StringTokenizer(conditionForProcess,";");
		boolean anyError = false; 
		while (tokens.hasMoreElements())
		{
			String eachCondition = tokens.nextToken();
			int idxFirstPoint = eachCondition.indexOf(".");
			int idxOperator = eachCondition.indexOf("!=");
			String originField = eachCondition.substring(idxFirstPoint+1,idxOperator);
			int idxSecondPoint = eachCondition.substring(idxOperator).indexOf(".");
			int idxMsgError = eachCondition.substring(idxOperator).indexOf("#ERROR");
			String targetField = eachCondition.substring(idxOperator).substring(idxSecondPoint+1,idxMsgError);
			if (eachCondition.startsWith("parentRow"))
				{
				DynamicDBean parentRowInForm = grid.getParentGrid().getSelectedRow();
				String valueOrigin;
				String valueTarget;
				if (parentRowInForm.getRowJSon().get(originField) == null)
					{
					DataService.get().showError("El campo ("+ originField+") no exite, en ("+parentRowInForm.getResourceName()+") revisar condición");
					break;
					}				
				else	
					valueOrigin = parentRowInForm.getRowJSon().get(originField).asText();
				DynamicDBean rowInOtherForm = dQGD.getGrid().getSelectedRow();
				if (rowInOtherForm.getRowJSon().get(targetField) == null)
					{
					DataService.get().showError("El campo ("+ targetField+") no exite, en ("+rowInOtherForm.getResourceName()+") revisar condición");					
					break;
					}
				else
					valueTarget = rowInOtherForm.getRowJSon().get(targetField).asText();
				if (valueOrigin.equals(valueTarget) == false)
					{
					String errorMsg = eachCondition.substring(idxOperator).substring(idxMsgError+6);
					DataService.get().showError(errorMsg);
					anyError = true;
		//			return false;
					}
//				else
//					{
//					return true;
//					}
				}
			else if (eachCondition.startsWith("rowTargetForm"))
			{
				DynamicDBean rowInOtherForm = dQGD.getGrid().getSelectedRow();
				if (rowInOtherForm.getRowJSon().get(originField) == null)
					{
					DataService.get().showError("El campo ("+ originField+") no exite, en ("+rowInOtherForm.getResourceName()+") revisar condición");					
					break;
					}
				else
				{
					String valueTargetToValidate = eachCondition.substring(idxOperator+2,eachCondition.indexOf("#ERROR"));
					String valueTarget = rowInOtherForm.getRowJSon().get(originField).asText();
					if (valueTargetToValidate.equals(valueTarget) == false)
					{
						String errorMsg = eachCondition.substring(idxOperator).substring(idxMsgError+6);
						DataService.get().showError(errorMsg);
						anyError = true;
					}
				}
			}	
			else
			{
				DataService.get().showError("no indicado parentRow o rowTargetForm. por ahora row. no implementado");
			}		
		}
		if (anyError == false)
			return true;
//		row.CampoOrigen!=rowTarget.Campo#ERROR;row.CampoOrigen2 != rowTarget.Campo2#ERROR
		errorInprocess = true;		
		return false;

		
	}
	private boolean isProcessable(DynamicDBean rowToGetData, String conditionForProcess) {
		int idxError = conditionForProcess.indexOf("#ERROR");
		if (idxError == -1)
			{
			DataService.get().showError("condicion para processo ("+conditionForProcess +") sin especificar #ERROR"); 
			return false;
			}
		StringTokenizer tokens = new StringTokenizer(conditionForProcess,";");
		boolean anyError = false; 
		while (tokens.hasMoreElements())
		{
			String eachCondition = tokens.nextToken();
			String fieldToGet = eachCondition.substring(conditionForProcess.indexOf(".")+1,idxError ); /// format row.field#ERROR or rowParent.field#ERROR
			JsonNode rowJson = rowToGetData.getRowJSon();
			if (rowJson.get(fieldToGet) == null)
			{
				DataService.get().showError("Campo para condición de procesable ("+fieldToGet+") no definido en recurso" );
			}
			if (rowJson.get(fieldToGet).asBoolean() == false)
				anyError = true;
		}
		if (anyError == false)
			return true;
		errorInprocess = true;		
		return false;
	}
	private DynamicQryGridDisplay getOpenUI(String idMenuOpenUIToProcess) {
		// TODO Auto-generated method stub
		return (DynamicQryGridDisplay) UtilSessionData.getOpenUI(idMenuOpenUIToProcess);
	}
	private void showResult(String filterForShowResult, String idButton) {
		String filter = componeFilter(filterForShowResult);
		processButtonForNavigation(idButton, null, null, null, filter);
//		menuRow = 
		
	}
	private String componeFilter(String filterForShowResult) { // sintasis -> field => <<FieldName1WithValue>> and .....<<FieldName2WithValue>> 
		String resultFilter = filterForShowResult;
		while (true)
		{
			int idxStartField = filterForShowResult.indexOf("<<");
			int inxEndField = filterForShowResult.indexOf(">>");
			if (idxStartField ==-1)
				break;
			String fieldToGetValue = filterForShowResult.substring(idxStartField+2,inxEndField);
			if (keepFirstParent == null)
				{
				DataService.get().showError("ERROR -> NO se ha creado ninún registro");
				break;
				}
			else
			{
				String value = keepFirstParent.getRowJSon().get(fieldToGetValue).asText();
				resultFilter = resultFilter.replace("<<"+fieldToGetValue+">>",value);
				filterForShowResult = filterForShowResult.substring(inxEndField+2);
			}	
		}
		return resultFilter;
	}

	private void proccesDataInputOuput(JsonNode rowStep, DynamicViewGrid grid, String inputResourceForReadData,
			DynamicDBean rowOfInputData) {// (DynamicDBean rowPreviousStep, JsonNode rowStep, DynamicViewGrid grid,
											// String inputResourceForReadData, DynamicDBean rowOfInputData) {
		Hashtable<Integer, DynamicDBean> beansFromGrid = new Hashtable<Integer, DynamicDBean>();
		Integer id = 0;
		DynamicDBean parentRowInForm = null;
		boolean hasMultiSelect = false;
		if (grid != null && grid.getParentGrid() != null)
			{
			parentRowInForm = grid.getParentGrid().getSelectedRow();
			hasMultiSelect = grid.getDataProvider().getIsMultiSelect();
			}
		if (rowStep.get("groupBy") != null && rowStep.get("groupBy").asText().startsWith("row")) // is only processed one 
																								// row   , row or rowParent
		{
			if (rowStep.get("groupBy").asText().endsWith("rowParent"))
				beansFromGrid.put(id, parentRowInForm);
			else				
				beansFromGrid.put(id, rowOfInputData);
		} else if (hasMultiSelect || rowStep.get("proccessOnlySelectedRow").asBoolean()) {
			Set<DynamicDBean> rowsStreamS = grid.getGrid().getSelectedItems();
//			grid.getGrid().getSelectedItems();j
//		grid.getGrid().getSelectedItems();j
			if (rowsStreamS.size() == 0) {
				errorInprocess  = true;
				DataService.get().showError("Dede de seleccionar un registro");
			} else {
				Iterator<DynamicDBean> rowsInput = rowsStreamS.iterator();
				String filterForInput = "null";
				if (rowStep != null)
					filterForInput = rowStep.get("filterForProcessInput").asText();
				while (rowsInput.hasNext()) {
					DynamicDBean rowInput = rowsInput.next();
					if (rowInput.getRowJSon().get("NotProcessRow") == null
							&& rowInput.getRowJSon().get(filterForInput) == null) //
					{
						beansFromGrid.put(id, rowInput);
						id++;
						System.out.println("GenericClassForMethods.proccesDataInputOuput() SI PROCESAR "
								+ rowInput.getRowJSon().get("cantidadPedirFinal"));
					} else {
						System.out.println("GenericClassForMethods.proccesDataInputOuput() NO PROCESAR "
								+ rowInput.getRowJSon().get("cantidadPedirFinal"));
					}

				}
			}
		} else {
			Stream<DynamicDBean> rowsStream = ((DataProvider<DynamicDBean, String>) grid.getGrid().getDataProvider()).fetch(createQuery(grid.getGrid()));
//			grid.getGrid().getSelectedItems();j
//		grid.getGrid().getSelectedItems();j
			Iterator<DynamicDBean> rowsInput = rowsStream.iterator();
			String filterForInput = "null";
			if (rowStep != null)
				filterForInput = rowStep.get("filterForProcessInput").asText();
			while (rowsInput.hasNext()) {
				DynamicDBean rowInput = rowsInput.next();
				if ((rowInput.getRowJSon().get("NotProcessRow") == null 
						|| rowInput.getRowJSon().get("NotProcessRow").equals("null") 
						|| rowInput.getRowJSon().get("NotProcessRow").asBoolean() == false) 
						&& rowInput.getRowJSon().get(filterForInput) == null) // 
				{
					beansFromGrid.put(id,rowInput);
					id++;
					System.out.println("GenericClassForMethods.proccesDataInputOuput() SI PROCESAR "+ rowInput.getRowJSon().get("cantidadPedirFinal"));
				}
				else
				{
					System.out.println("GenericClassForMethods.proccesDataInputOuput() NO PROCESAR "+ rowInput.getRowJSon().get("cantidadPedirFinal"));
				}
			
		}
		}
		DynamicDBean row = null;
		DynamicDBean lastParent = null;
		String groupBy = rowStep.get("groupBy").asText();
		if (groupBy.startsWith("row") == false)  // when groupBy is "row"  or "rowParent" then only one row is processed
			{
			String keepGroup = null;
			int i = 0;
			DynamicDBean firstRowInput = null ;
			while (beansFromGrid.size() > i) {

				if (i == 0) // first row
				{
					firstRowInput = beansFromGrid.get(0);
					lastParent = insertOrUpdateOutput(firstRowInput, rowStep, true, lastParent, parentRowInForm, grid);//(firstRowInput, rowStep, true, lastParent, rowPreviousStep);
					if ((lastParent == null && dQGD == null) || (lastParent != null && lastParent.getParams() != null && lastParent.getParams().startsWith("ERROR WITH INSERT")))	 // it means a error , not more rows are proccesed 	 // when is the type dQGD it means that there is a form to add items, then not parent 
						i=999999;
					keepFirstParent = lastParent;
					if (groupBy.equals("null") == false && groupBy.equals("row") == false)
						if (firstRowInput.getRowJSon() != null && firstRowInput.getRowJSon().get(groupBy) != null )
							keepGroup = firstRowInput.getRowJSon().get(groupBy).asText();				
				}
				else
				{
					row = beansFromGrid.get(i);
					if (row != null)
					{
//	!!!!!			System.out.println("GenericClassForMethods.proccesDataInputOuput() ROW INPUT --->"+ row.getRowJSon().get("DESCRIPCION").asText());
					if (keepGroup != null && row.getRowJSon().get(groupBy).asText().equals(keepGroup) == false) // Group change
						{
						lastParent = insertOrUpdateOutput(row, rowStep, true, lastParent, parentRowInForm, grid);
						if (lastParent == null || (lastParent.getParams() != null && lastParent.getParams().startsWith("ERROR WITH INSERT")))	 // it means a error , not more rows are proccesed 	 // it means a error , not more rows are processed 
							i=999999;

						keepGroup = row.getRowJSon().get(groupBy).asText();
						}
					else
						{
						DynamicDBean newRow = insertOrUpdateOutput(row, rowStep, false, lastParent, parentRowInForm, grid);
						if (newRow == null || newRow.getCol0().equals("ERROR WITH INSERT"))	 // it) //(row, rowStep, false, lastParent, rowOfInputData);
							i=999999;
						}
					}
				}	
				i++;
//			System.out.println("GenericClassForMethods.processInput() EACH Row in grid " + row.getCol0() + " "+  row.getRowJSon().asText() );
			}
		}
		else  // only one row is processed
		{
			DynamicDBean RowInput = beansFromGrid.get(0);
			lastParent = insertOrUpdateOutput(RowInput, rowStep, true, lastParent, parentRowInForm, grid);//(firstRowInput, rowStep, true, lastParent, rowPreviousStep);
		}
//		JsonNode rowsStepOuput = rowStep.get("List-ProcessStepOutput");
//		processInputOuput(grid, inputResourceForReadData, rowOfInputData, rowsStepOuput);
//
//		if (rowPreviousStep != null)
//		{
//			System.out.println("GenericClassForMethods.proccesDataInputOuput() rowPreviousStep.getCol0()=" + rowPreviousStep.getCol0());
//		}
//		for (JsonNode rowStepOuput : rowsStepOuput) 
//			{
//			System.out.println("GenericClassForMethods.processButtonForProcess() STEP OUTPUT "+ rowStepOuput.get("resource").asText());
//			}
//		return keepFirstParent;
	}
	private DynamicDBean insertOrUpdateOutput(DynamicDBean rowInputData, JsonNode rowStep, boolean isNewForGroupChange, DynamicDBean lastParent, DynamicDBean parentRowInForm, DynamicViewGrid grid) {//(DynamicDBean rowInputData, JsonNode rowStep, boolean isNewForGroupChange, DynamicDBean lastParent, DynamicDBean rowPreviousStep) {
//		if (rowStep.get("filter"))
		
		JsonNode rowsStepOuput = rowStep.get("List-ProcessStepOutput");
		for (JsonNode rowStepOuput : rowsStepOuput) 
		{ //
			JsonNode ouputResource = rowStepOuput.get("resource"); 
			if (rowStep.get("inputResourceForReadData").equals(rowStepOuput.get("resource"))) // when the input and output are the same row then is an update
			{
				lastParent = updateAnOuputRow(rowStepOuput, null, rowInputData, grid);
			}
			else if (ouputResource != null && ouputResource.asText().indexOf("@form@") > -1) // the output is in a resource of a form 
			{
				System.out.println("GenericClassForMethods.insertOrUpdateOutput() + TITULO  form a procesar: " + dQGD.getPageTitle());
				String ouputResourceStr = ouputResource.asText().substring(6);
				DynamicViewGrid subgridToAddItem = dQGD.getDvgIntheForm().get(ouputResourceStr);
				if ( subgridToAddItem == null)
				{
					DataService.get().showError("ERROR -> Listado para insertar sin abrir, el registro donde se quiere añadir la linea ha de estar abierto");
					return null;
				}
			//	subgridToAddItem.setRowIsInserted(insertAnOuputRow(rowStepOuput, lastParent, rowInputData));
				DynamicDBean newItem = insertAnOuputRowInAForm(rowStepOuput, rowInputData);	
				newItem.setFilter(subgridToAddItem.getFilter());
				subgridToAddItem.insertBeanInList(); // prepare a new item
				subgridToAddItem.setRowIsInserted(newItem); // fills data
				subgridToAddItem.insertBeanInList(); // saves the item
				///refresh the row
				DynamicDBean parentRow = subgridToAddItem.getParentGrid().getSelectedRow();
				subgridToAddItem.getParentGrid().setSelectedRow(parentRow);//.showBean(parentRow);
			     Broadcaster.broadcast("Actualizado desde otro formulario");
			    return newItem;
//			        message.setValue("");
//				dQGD.getPage().reload();
//				dQGD.createContent();//.notify();
				}
			else if (rowStepOuput.get("childOf").asText().equals("null")) // is root ouput row
			{
				String filter = rowStepOuput.get("filter").asText();
				if (rowStepOuput.get("filter").asText().equals("null") && isNewForGroupChange) // is new row for groupBy change in root 
				{
					lastParent = //insertAnOuputRow(rowStepOuput, null, rowPreviousStep);
								 insertAnOuputRow(rowStepOuput, null, rowInputData, parentRowInForm);//(DynamicDBean rowInputData, JsonNode rowStep, boolean isNewForGroupChange, DynamicDBean lastParent, DynamicDBean rowPreviousStep) {
				}
//				else if (filter.equals("null") == false && filter.indexOf("rowAD.") > -1 ) // if the rowAD.field has data it means that the a row is not created
//				{
//					System.out.println("PROCEESS AN UPDATE or INSERT for " +rowStepOuput.get("resource"));
//					lastParent = checkIfParentExistAndHaveSameData(rowStepOuput);
//				}
				else if (isNewForGroupChange) // is a new row by a group change but is not a insert it updates the ouput
				{
					System.out.println("PROCEESS AN UPDATE for " +rowStepOuput.get("resource"));
				}
			}
			else // is a ChildRow
			{
	//			insertAnOuputRow(rowStepOuput, lastParent, rowPreviousStep);
				DynamicDBean newChild = insertAnOuputRow(rowStepOuput, lastParent, rowInputData, parentRowInForm);//(rowStepOuput, lastParent, rowInputData, rowPreviousStep);
				if (newChild.getCol0().equals("ERROR WITH INSERT"))			
					{
					lastParent.setParams("ERROR WITH INSERT##"+lastParent.getParams());
					return lastParent;
					}
						
			}
				
//			System.out.println("GenericClassForMethods.processButtonForProcess() STEP OUTPUT "+ rowStepOuput.get("resource").asText());
		}
		
		return lastParent;

		
	}
	/// instead of ask for a key, we do with 2 buttons combined with a form open where the childs will be add, 
//	private DynamicDBean checkIfParentExistAndHaveSameData(JsonNode rowStepOuput) {
//		// TODO Auto-generated method stub
//		return null;
//	}
	private DynamicDBean insertAnOuputRow(JsonNode rowStepOuput, DynamicDBean lastParent, DynamicDBean rowInputData, DynamicDBean parentRowInForm) {//(JsonNode rowStepOuput, DynamicDBean lastParent, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		String ouputResource = rowStepOuput.get("resource").asText();
		System.out.println("PROCEESS AN INSERT for " +ouputResource);
		DynamicDBean newBean = new DynamicDBean(); 
		DdbDataBackEndProvider dataProviderOuput = new DdbDataBackEndProvider();
		dataProviderOuput.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		dataProviderOuput.setResourceName(ouputResource);
		
		newBean.setResourceName(rowStepOuput.get("resource").asText());
		newBean.setRowsColList(dataProviderOuput.getRowsColList());
		newBean.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		GeneratedUtil.fillDefaultValues(newBean);
		newBean = fillDataOuput(newBean, rowStepOuput, rowInputData, parentRowInForm);//(newBean, rowStepOuput, rowInputData, rowPreviousStep);
		Hashtable<String, DynamicDBean> beansToSaveAndRefresh = new Hashtable<String, DynamicDBean>(); // to send DynamicDBean to be save and refresh, the name of the one to be save is send in another param
		beansToSaveAndRefresh.clear();
		beansToSaveAndRefresh.put(newBean.getResourceName(), newBean);
		if (lastParent != null)
		{
			beansToSaveAndRefresh.put(lastParent.getResourceName(), lastParent);
	//		if (resourceSubGrid2.indexOf(".")> -1)
			newBean.setFilter(DataService.get().componFKFilter(lastParent, ouputResource));

		}

		if (dataProviderOuput.save(newBean.getResourceName(), beansToSaveAndRefresh)==true)	
		{
			DynamicDBean beanWithError = new DynamicDBean();
			beanWithError.setCol0("ERROR WITH INSERT");
			return beanWithError;
		}
		return newBean;

		
	}
	private DynamicDBean updateAnOuputRow(JsonNode rowStepOuput, DynamicDBean lastParent, DynamicDBean rowInputData, DynamicViewGrid grid) {//(JsonNode rowStepOuput, DynamicDBean lastParent, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		String ouputResource = rowStepOuput.get("resource").asText();
		System.out.println("PROCEESS AN UPDATE for " +ouputResource);
		DdbDataBackEndProvider dataProviderOuput = new DdbDataBackEndProvider();
		dataProviderOuput.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		dataProviderOuput.setResourceName(ouputResource);
		
		rowInputData = fillDataOuput(rowStepOuput, rowInputData);//(newBean, rowStepOuput, rowInputData, rowPreviousStep);
		Hashtable<String, DynamicDBean> beansToSaveAndRefresh = new Hashtable<String, DynamicDBean>(); // to send DynamicDBean to be save and refresh, the name of the one to be save is send in another param
		beansToSaveAndRefresh.clear();
		beansToSaveAndRefresh.put(rowInputData.getResourceName(), rowInputData);

		if (dataProviderOuput.save(rowInputData.getResourceName(), beansToSaveAndRefresh)==true)	
		{
			DynamicDBean beanWithError = new DynamicDBean();
			beanWithError.setCol0("ERROR WITH INSERT");
			return beanWithError;
		}
		else if (grid != null)
		{
			if (grid.getDataProvider().getResourceName().equals(rowInputData.getResourceName()))
				grid.getDataProvider().refreshAll();//(rowInputData);
			else
	//			dataProviderOuput.refreshAll();
				if (grid.getParentGrid() != null)
					grid.getParentGrid().showBean(rowInputData);
				else
				{
					if ( grid.getGrid().getSelectedItems().isEmpty())
						DataService.get().showError("Seleccionar registro para refrescar recalculo");
					else
						{	
						DynamicDBean selectedRow = grid.getGrid().getSelectedItems().iterator().next();
						grid.showBean(selectedRow);
						}
//					grid.setSelectedRow(rowInputData);
				}
		}
		else
		{
			dataProviderOuput.refresh(rowInputData);
		}
		return rowInputData;

		
	}
	private DynamicDBean insertAnOuputRowInAForm(JsonNode rowStepOuput, DynamicDBean rowInputData) {//(JsonNode rowStepOuput, DynamicDBean lastParent, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		String ouputResource = rowStepOuput.get("resource").asText().substring(6); // to clean @form@
		System.out.println("PROCEESS AN INSERT for " +ouputResource);
		DynamicDBean newBean = new DynamicDBean(); 
		DdbDataBackEndProvider dataProviderOuput = new DdbDataBackEndProvider();
		dataProviderOuput.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		dataProviderOuput.setResourceName(ouputResource);
		
		newBean.setResourceName(ouputResource);
		newBean.setRowsColList(dataProviderOuput.getRowsColList());
		newBean.setPreConfParam(UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		GeneratedUtil.fillDefaultValues(newBean);
		newBean = fillDataOuput(newBean, rowStepOuput, rowInputData, null);//(newBean, rowStepOuput, rowInputData, rowPreviousStep);
		Hashtable<String, DynamicDBean> beansToSaveAndRefresh = new Hashtable<String, DynamicDBean>(); // to send DynamicDBean to be save and refresh, the name of the one to be save is send in another param
		beansToSaveAndRefresh.clear();
		beansToSaveAndRefresh.put(newBean.getResourceName(), newBean);
//		if (lastParent != null)
//		{
//			beansToSaveAndRefresh.put(lastParent.getResourceName(), lastParent);
//			newBean.setFilter(DataService.get().componFKFilter(lastParent, ouputResource));
//
//		}

//		dataProviderOuput.save(newBean.getResourceName(), beansToSaveAndRefresh);	

		return newBean;

		
	}
	private DynamicDBean fillDataOuput( JsonNode rowStepOuput, DynamicDBean rowInputData) {//fillDataOuput(DynamicDBean newBean, JsonNode rowStepOuput, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		JsonNode rowsStepOuputMap = rowStepOuput.get("List-ProcessStepOutputMap");
		ArrayList<String[]> colList = rowInputData.getRowsColList();
		for (JsonNode rowStepOuputMap : rowsStepOuputMap) 
		{
			rowInputData.setCol(rowStepOuputMap.get("fieldValue").asText(), getColNameInUi(rowStepOuputMap.get("ouputField").asText(), colList, rowStepOuput.get("resource").asText() ));
		}
		return rowInputData;
	//	Orvisa@.03
		
	}
	private DynamicDBean fillDataOuput(DynamicDBean newBean, JsonNode rowStepOuput, DynamicDBean rowInputData, DynamicDBean parentRowInForm) {//fillDataOuput(DynamicDBean newBean, JsonNode rowStepOuput, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		JsonNode rowsStepOuputMap = rowStepOuput.get("List-ProcessStepOutputMap");
		ArrayList<String[]> colList = newBean.getRowsColList();
		for (JsonNode rowStepOuputMap : rowsStepOuputMap) 
		{
			String valueForField = getValueForField(rowStepOuputMap.get("fieldValue").asText(), rowInputData, parentRowInForm);
			String colNameInUi = getColNameInUi(rowStepOuputMap.get("ouputField").asText(), colList, rowStepOuput.get("resource").asText() );
			newBean.setCol(valueForField, colNameInUi);
		}
		return newBean;
	//	Orvisa@.03
		
	}
	private String getColNameInUi(String colName, ArrayList<String[]> colList, String resource) {
//		colName
		int idxCol = colList.indexOf(colName);
		String[] col = findCol(colList, colName) ;
		if (col == null)
		{
			DataService.get().showError("ERROR -> Campo sin definir en metaconfig : " +colName + " del recurso "+ resource);
			return null;
		}
		System.out.println("GenericClassForMethods.getColNameInUi() colName "+ colName +  " col[2] " +col[2] );
		return col[2];
	}
	private String[] findCol(ArrayList<String[]> colList, String colName) {
		for (int i = 0; i < colList.size(); i++) {
			
		if (colList.get(i)[0].equals(colName))
			{
			return colList.get(i);
			}
			
		}
		return null;
	}
	private String getValueForField(String valueFormula, DynamicDBean rowInputData, DynamicDBean parentRowInForm) {//(String valueFormula, DynamicDBean rowInputData, DynamicDBean rowPreviousStep) {
		if (valueFormula.indexOf("rowPD") > -1)
		{
			int idxStart = valueFormula.indexOf("rowPD") + 6;
			String colNameToGetValue = valueFormula.substring(idxStart);
			String colNameInUi = getColNameInUi(colNameToGetValue, parentRowInForm.getRowsColList(),parentRowInForm.getResourceName());
			System.out.println("rowPD GenericClassForMethods.getValueForField() valueFormula "+ valueFormula + " colNameInUi " + colNameInUi + " value "+ parentRowInForm.getCol(colNameInUi));
			return parentRowInForm.getCol(colNameInUi);
		}
		if (valueFormula.indexOf("rowID") > -1)
		{
			int idxStart = valueFormula.indexOf("rowID") + 6;
			String colNameToGetValue = valueFormula.substring(idxStart);
			String colNameInUi = getColNameInUi(colNameToGetValue, rowInputData.getRowsColList(),rowInputData.getResourceName());
			System.out.println("rowID GenericClassForMethods.getValueForField() valueFormula "+ valueFormula + " colNameInUi " + colNameInUi + " value "+ rowInputData.getCol(colNameInUi));
			return rowInputData.getCol(colNameInUi);
		}
		if (valueFormula.indexOf("rowAD") > -1)
		{
			int idxStart = valueFormula.indexOf("rowAD") + 6;
			String colNameToGetValue = valueFormula.substring(idxStart);
			/// AQUI /////
			String colNameInUi = getColNameInUi(colNameToGetValue, rowOfAskData.getRowsColList(), rowInputData.getResourceName());
			System.out.println("rowAD GenericClassForMethods.getValueForField() valueFormula "+ valueFormula + " colNameInUi " + colNameInUi + " value "+ rowInputData.getCol(colNameInUi));
			return rowOfAskData.getCol(colNameInUi);
		}
		return null;
	}
	private void askForDataAndContinue(String dialogClassLayout, String inputResourceForAskData, DynamicViewGrid grid, String dialogClassDisplayForm, JsonNode rowStep, DynamicDBean rowOfInputData) {
		DynamicDisplayForAskData dynamicDisplayForAskData = new DynamicDisplayForAskData();
		
		rowOfAskData = RestData.getOneRow(inputResourceForAskData, null, UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
		String defaultData = rowStep.get("mapDefaultInputDataForAskData").asText();
		if (defaultData.isEmpty() == false && defaultData.equals("null") == false)
		{
			StringTokenizer tokens = new StringTokenizer(defaultData,"#");  // format coln1;Fielname1#coln2;Fielname2
			while (tokens.hasMoreElements())
			{
				String eachFieldMap = tokens.nextToken();
				int idxSeparator = eachFieldMap.indexOf(";");
				String colnameOuput = eachFieldMap.substring(0, idxSeparator);
				String colnameInput = eachFieldMap.substring(idxSeparator+1);
				String inputdata = null;
				if (rowOfInputData != null)
					inputdata = rowOfInputData.getRowJSon().get(colnameInput).asText();
				else if (colnameInput.startsWith("parentRow"))
					{
					inputdata = grid.getParentGrid().getSelectedRow().getRowJSon().get(colnameInput.substring(10)).asText();
					}
				else if (colnameInput.startsWith("row"))
					{
					inputdata = grid.getSelectedRow().getRowJSon().get(colnameInput.substring(4)).asText();
					}
				rowOfAskData.setCol(inputdata, colnameOuput);						
			}
			
		}
		this.actualRowStep = rowStep;
		this.actualGrid = grid;
		this.actualRowOfInputData = rowOfInputData;
		dynamicDisplayForAskData.setClassForMethod(this);
// 		dynamicDisplayForAskData.addAcceptDataAndContinueListener(e -> nextStepIfExist(rowStep, grid, rowOfInputData, null));//(rowOfAskData, rowStep, grid)); // is not use a generic button, all the buttons are paint in generated form
		//Object rowOfInputData = 
		askInputData(inputResourceForAskData, grid, dialogClassLayout, dialogClassDisplayForm, dynamicDisplayForAskData, rowOfAskData);
	}


	
	private Object nextStepIfExist(JsonNode step, DynamicViewGrid grid, DynamicDBean rowOfInputData, String idNextStep) {//(DynamicDBean rowtoShow, JsonNode step, DynamicViewGrid grid) {
//		System.out.println("GenericClassForMethods.nextStepAfterAskData() " + rowOfAskData.getCol0());
		JsonNode nextStep = foundNextStep(step, idNextStep);
		if (nextStep != null && errorInprocess == false)
			processSteps(nextStep.get(0), grid, rowOfInputData);
		else if (dialogToAskData != null && dialogToAskData.isOpened())
				dialogToAskData.close();
		return null;
	}
	private JsonNode foundNextStep(JsonNode step, String idNextStep) {
		int idProcces = step.get("idProcess").asInt();
		int sequence = step.get("sequence").asInt()+1;
		String filter = "idProcess="+idProcces+"%20AND%20sequence="+sequence;
		if (idNextStep !=null && idNextStep.length() > 0)
			filter = "idProcess="+idProcces+"%20AND%20idNextStep='"+idNextStep+"'";
		try {
			JsonNode rowsList = JSonClient.get("CR-Process.List-ProcessStep",filter,false,AppConst.PRE_CONF_PARAM_METADATA,100+"");  // 100 maximun number of rows in child nodes, ouputs, ouputMap
			if (rowsList.size() > 0)
				return rowsList;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		
		return null;
	}
	private void processInputOuput(DynamicViewGrid grid, String inputResourceForReadData, DynamicDBean rowOfInputData, JsonNode rowsStepOuput) {
		Stream<DynamicDBean> rowsStream = ((DataProvider<DynamicDBean, String>) grid.getGrid().getDataProvider()).fetch(createQuery(grid.getGrid()));
//		grid.getGrid().getSelectedItems();j
		Iterator<DynamicDBean> rows = rowsStream.iterator();
		DynamicDBean row = null;
		while (rows.hasNext()) {
			row = rows.next();
			System.out.println("GenericClassForMethods.processInput() EACH Row in grid " + row.getCol0() + " "+  row.getRowJSon().asText() );
		}
			
		
		
	}
	private DynamicDBean askInputData(String inputResourceForAskData, DynamicViewGrid grid, String layoutClassName, String displayFormClassName, DynamicDisplayForAskData dynamicDisplayForAskData, DynamicDBean rowtoShow) {
//		DynamicDBean rowtoShow = RestData.getOneRow(inputResourceForAskData, null, UtilSessionData.getCompanyYear()+AppConst.PRE_CONF_PARAM);
//		String layoutClassName="coop.intergal.ui.views.DynamicDisplaySubgrid"; 
//		String displayFormClassName = "coop.intergal.ui.views.GeneratedDetails";  
		String filterForPopup = null ;
		rowtoShow= showDialog(rowtoShow, inputResourceForAskData, layoutClassName, displayFormClassName, grid, filterForPopup, dynamicDisplayForAskData);
		return rowtoShow;
		
	}

    /*
     * This method is needed if using Vaadin 14, which does not have DataView API yet
     */
    private Query<DynamicDBean, String> createQuery(Grid<DynamicDBean> grid) {
        List<GridSortOrder<DynamicDBean>> gridSort = grid.getSortOrder();
        List<QuerySortOrder> sortOrder = gridSort
            .stream()
            .map(order -> order.getSorted().getSortOrder(order.getDirection()))
            .flatMap(orders -> orders)
            .collect(Collectors.toList());

        BinaryOperator<SerializableComparator<DynamicDBean>> operator = (comparator1, comparator2) -> {
            return comparator1.thenComparing(comparator2)::compare;
        };
        SerializableComparator<DynamicDBean> inMemorySorter = gridSort
            .stream()
            .map(order -> order.getSorted().getComparator(order.getDirection()))
            .reduce(operator)
            .orElse(null);
// @@ TODO handle The Integer.MAX_VALUE to avoid large numer of rows to procces 
        return new Query<DynamicDBean, String>(0, Integer.MAX_VALUE, sortOrder, inMemorySorter, null);
    }
}
