// Do not edit this file; automatically generated by build.py.
'use strict';

// Copyright 2012 Google Inc.  Apache License 2.0
Blockly.Java = new Blockly.Generator("Java");
Blockly.Java.addReservedWords("abstract,continue,for,new,switch,assert,default,goto,package,synchroniz ed,boolean,do,if,private,this,break,double,implements,protected,throw,byte,else,import,public,throws,case,enum,instanceof,return,transient,catch,extends,int,short,try,char,final,interface,static,void,class,finally,long,strictfp,volatile,const,float,native,super,while");
Blockly.Java.ORDER_ATOMIC = 0;
Blockly.Java.ORDER_UNARY_POSTFIX = 1;
Blockly.Java.ORDER_UNARY_PREFIX = 2;
Blockly.Java.ORDER_MULTIPLICATIVE = 3;
Blockly.Java.ORDER_ADDITIVE = 4;
Blockly.Java.ORDER_SHIFT = 5;
Blockly.Java.ORDER_RELATIONAL = 6;
Blockly.Java.ORDER_EQUALITY = 7;
Blockly.Java.ORDER_BITWISE_AND = 8;
Blockly.Java.ORDER_BITWISE_XOR = 9;
Blockly.Java.ORDER_BITWISE_OR = 10;
Blockly.Java.ORDER_LOGICAL_AND = 11;
Blockly.Java.ORDER_LOGICAL_OR = 12;
Blockly.Java.ORDER_TERNARY = 13;
Blockly.Java.ORDER_ASSIGNMENT = 14;
Blockly.Java.ORDER_NONE = 99;
Blockly.Java.init = function(a) {
    Blockly.Java.definitions_ = Object.create(null);
    Blockly.Java.functionNames_ = Object.create(null);
    Blockly.Java.variableDB_ ? Blockly.Java.variableDB_.reset() : Blockly.Java.variableDB_ = new Blockly.Names(Blockly.Java.RESERVED_WORDS_);
    var b = [];
    a = Blockly.Variables.allVariables(a);
    for (var c = 0; c < a.length; c++) b[c] = "var " + Blockly.Java.variableDB_.getName(a[c], Blockly.Variables.NAME_TYPE) + ";";
    Blockly.Java.definitions_.variables = b.join("\n")
};
Blockly.Java.finish = function(a) {
    var b = [],
        c;
    for (c in Blockly.Java.definitions_) b.push(Blockly.Java.definitions_[c]);
    delete Blockly.Java.definitions_;
    delete Blockly.Java.functionNames_;
    Blockly.Java.variableDB_.reset();
    return b.join("\n\n") + "\n\n\n" + a
};
Blockly.Java.scrubNakedValue = function(a) {
    return a + ";\n"
};
Blockly.Java.quote_ = function(a) {
    a = a.replace(/\\/g, "\\\\").replace(/\n/g, "\\\n").replace(/'/g, "\\'");
    return '"' + a + '"'
};
Blockly.Java.scrub_ = function(a, b) {
    var c = "";
    if (!a.outputConnection || !a.outputConnection.targetConnection) {
        var d = a.getCommentText();
        d && (c += Blockly.Java.prefixLines(d, "// ") + "\n");
        for (var e = 0; e < a.inputList.length; e++) a.inputList[e].type == Blockly.INPUT_VALUE && (d = a.inputList[e].connection.targetBlock()) && (d = Blockly.Java.allNestedComments(d)) && (c += Blockly.Java.prefixLines(d, "// "))
    }
    e = a.nextConnection && a.nextConnection.targetBlock();
    e = Blockly.Java.blockToCode(e);
    return c + b + e
};
Blockly.Java.colour = {};
Blockly.Java.colour_picker = function(a) {
    return ["'" + a.getFieldValue("COLOUR") + "'", Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.colour_random = function(a) {
    return [Blockly.Java.provideFunction_("colour_random", ["function " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "() {", "  var num = Math.floor(Math.random() * Math.pow(2, 24));", "  return '#' + ('00000' + num.toString(16)).substr(-6);", "}"]) + "()", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.colour_rgb = function(a) {
    var b = Blockly.Java.valueToCode(a, "RED", Blockly.Java.ORDER_COMMA) || 0,
        c = Blockly.Java.valueToCode(a, "GREEN", Blockly.Java.ORDER_COMMA) || 0;
    a = Blockly.Java.valueToCode(a, "BLUE", Blockly.Java.ORDER_COMMA) || 0;
    return [Blockly.Java.provideFunction_("colour_rgb", ["function " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(r, g, b) {", "  r = Math.max(Math.min(Number(r), 100), 0) * 2.55;", "  g = Math.max(Math.min(Number(g), 100), 0) * 2.55;", "  b = Math.max(Math.min(Number(b), 100), 0) * 2.55;",
        "  r = ('0' + (Math.round(r) || 0).toString(16)).slice(-2);", "  g = ('0' + (Math.round(g) || 0).toString(16)).slice(-2);", "  b = ('0' + (Math.round(b) || 0).toString(16)).slice(-2);", "  return '#' + r + g + b;", "}"
    ]) + "(" + b + ", " + c + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.colour_blend = function(a) {
    var b = Blockly.Java.valueToCode(a, "COLOUR1", Blockly.Java.ORDER_COMMA) || "'#000000'",
        c = Blockly.Java.valueToCode(a, "COLOUR2", Blockly.Java.ORDER_COMMA) || "'#000000'";
    a = Blockly.Java.valueToCode(a, "RATIO", Blockly.Java.ORDER_COMMA) || .5;
    return [Blockly.Java.provideFunction_("colour_blend", ["function " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(c1, c2, ratio) {", "  ratio = Math.max(Math.min(Number(ratio), 1), 0);", "  var r1 = parseInt(c1.substring(1, 3), 16);", "  var g1 = parseInt(c1.substring(3, 5), 16);",
        "  var b1 = parseInt(c1.substring(5, 7), 16);", "  var r2 = parseInt(c2.substring(1, 3), 16);", "  var g2 = parseInt(c2.substring(3, 5), 16);", "  var b2 = parseInt(c2.substring(5, 7), 16);", "  var r = Math.round(r1 * (1 - ratio) + r2 * ratio);", "  var g = Math.round(g1 * (1 - ratio) + g2 * ratio);", "  var b = Math.round(b1 * (1 - ratio) + b2 * ratio);", "  r = ('0' + (r || 0).toString(16)).slice(-2);", "  g = ('0' + (g || 0).toString(16)).slice(-2);", "  b = ('0' + (b || 0).toString(16)).slice(-2);", "  return '#' + r + g + b;",
        "}"
    ]) + "(" + b + ", " + c + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.lists = {};
Blockly.Java.lists_create_empty = function(a) {
    return ["[]", Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.lists_create_with = function(a) {
    for (var b = Array(a.itemCount_), c = 0; c < a.itemCount_; c++) b[c] = Blockly.Java.valueToCode(a, "ADD" + c, Blockly.Java.ORDER_COMMA) || "null";
    b = "[" + b.join(", ") + "]";
    return [b, Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.lists_repeat = function(a) {
    var b = Blockly.Java.provideFunction_("lists_repeat", ["Object[] " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(value, n) {", "  var array = [];", "  for (var i = 0; i < n; i++) {", "    array[i] = value;", "  }", "  return array;", "}"]),
        c = Blockly.Java.valueToCode(a, "ITEM", Blockly.Java.ORDER_COMMA) || "null";
    a = Blockly.Java.valueToCode(a, "NUM", Blockly.Java.ORDER_COMMA) || "0";
    return [b + "(" + c + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.lists_length = function(a) {
    return [(Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_FUNCTION_CALL) || "[]") + ".length", Blockly.Java.ORDER_MEMBER]
};
Blockly.Java.lists_isEmpty = function(a) {
    return ["Arrays.asList(" + (Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "[]") + ").isEmpty()", Blockly.Java.ORDER_LOGICAL_NOT]
};
Blockly.Java.lists_indexOf = function(a) {
    var b = "FIRST" == a.getFieldValue("END") ? "indexOf" : "lastIndexOf",
        c = Blockly.Java.valueToCode(a, "FIND", Blockly.Java.ORDER_NONE) || "''";
    return ["Arrays.asList(" + (Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "[]") + ")." + b + "(" + c + ") + 1", Blockly.Java.ORDER_MEMBER]
};
Blockly.Java.lists_getIndex = function(a) {
    var b = a.getFieldValue("MODE") || "GET",
        c = a.getFieldValue("WHERE") || "FROM_START",
        d = Blockly.Java.valueToCode(a, "AT", Blockly.Java.ORDER_UNARY_NEGATION) || "1";
    a = Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "[]";
    if ("FIRST" == c) {
        if ("GET" == b) return ["Arrays.asList(" + a + ").get(0)", Blockly.Java.ORDER_MEMBER];
        if ("GET_REMOVE" == b) return ["Arrays.asList(" + a + ").get(0);\nArrays.asList(" + a + ").removeAt(0)", Blockly.Java.ORDER_MEMBER];
        if ("REMOVE" == b) return "Arrays.asList(" +
            a + ").removeAt(0);\n"
    } else if ("LAST" == c) {
        if ("GET" == b) return [a + ".slice(-1)[0]", Blockly.Java.ORDER_MEMBER];
        if ("GET_REMOVE" == b) return ["Arrays.asList(" + a + ").get(" + a + ".length - 1);\nArrays.asList(" + a + ").removeAt(" + a + ".length - 1);\n", Blockly.Java.ORDER_MEMBER];
        if ("REMOVE" == b) return "Arrays.asList(" + a + ").removeAt(" + a + ".length - 1);\n"
    } else if ("FROM_START" == c) {
        d = Blockly.isNumber(d) ? parseFloat(d) - 1 : d + " - 1";
        if ("GET" == b) return ["Arrays.asList(" + a + ").get(" + d + ")", Blockly.Java.ORDER_MEMBER];
        if ("GET_REMOVE" == b) return ["Arrays.asList(" +
            a + ").get(" + d + ");\nArrays.asList(" + a + ").removeAt(" + d + ")", Blockly.Java.ORDER_FUNCTION_CALL
        ];
        if ("REMOVE" == b) return "Arrays.asList(" + a + ").removeAt(" + d + ");\n"
    }
    throw "Unhandled or Not implemented combination (lists_getIndex).";
};
Blockly.Java.lists_setIndex = function(a) {
    var b = Blockly.Java.valueToCode(a, "LIST", Blockly.Java.ORDER_MEMBER) || "[]",
        c = a.getFieldValue("MODE") || "GET",
        d = a.getFieldValue("WHERE") || "FROM_START",
        e = Blockly.Java.valueToCode(a, "AT", Blockly.Java.ORDER_NONE) || "1";
    a = Blockly.Java.valueToCode(a, "TO", Blockly.Java.ORDER_ASSIGNMENT) || "null";
    if ("FIRST" == d) {
        if ("SET" == c || "INSERT" == c) return "Arrays.asList(" + b + ").set(0, " + a + ");\n"
    } else if ("LAST" == d) {
        if ("SET" == c) return b.match(/^\w+$/) ? c = "" : (c = Blockly.Java.variableDB_.getDistinctName("tmp_list",
            Blockly.Variables.NAME_TYPE), d = "var " + c + " = " + b + ";\n", b = c, c = d), c + (b + "[" + b + ".length - 1] = " + a + ";\n");
        if ("INSERT" == c) return "Arrays.asList(" + b + ").set(" + b + ".length - 1, " + a + ");"
    } else if ("FROM_START" == d) {
        e = Blockly.isNumber(e) ? parseFloat(e) - 1 : e + " - 1";
        if ("SET" == c) return b + "[" + e + "] = " + a + ";\n";
        if ("INSERT" == c) return "Arrays.asList(" + b + ").set(" + e + ", " + a + ");"
    }
    throw "Unhandled combination or Not Implemented (lists_setIndex).";
};
Blockly.Java.lists_getSublist = function(a) {
    var b = Blockly.Java.valueToCode(a, "LIST", Blockly.Java.ORDER_MEMBER) || "[]",
        c = Blockly.Java.valueToCode(a, "AT1", Blockly.Java.ORDER_NONE) || "1";
    a = Blockly.Java.valueToCode(a, "AT2", Blockly.Java.ORDER_NONE) || "1";
    return ["Arrays.asList(" + b + ").subList(" + c + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.lists_split = function(a) {
    var b = Blockly.Java.valueToCode(a, "INPUT", Blockly.Java.ORDER_MEMBER),
        c = Blockly.Java.valueToCode(a, "DELIM", Blockly.Java.ORDER_NONE) || "''";
    a = a.getFieldValue("MODE");
    if ("SPLIT" == a) b || (b = "''");
    else throw "Unknown mode: " + a;
    return [b + ".split(" + c + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.logic = {};
Blockly.Java.controls_if = function() {
    for (var a = 0, b = Blockly.Java.valueToCode(this, "IF" + a, Blockly.Java.ORDER_NONE) || "false", c = Blockly.Java.statementToCode(this, "DO" + a), d = "if (" + b + ") {\n" + c + "\n}", a = 1; a <= this.elseifCount_; a++) b = Blockly.Java.valueToCode(this, "IF" + a, Blockly.Java.ORDER_NONE) || "false", c = Blockly.Java.statementToCode(this, "DO" + a), d += " else if (" + b + ") {\n" + c + "}";
    this.elseCount_ && (c = Blockly.Java.statementToCode(this, "ELSE"), d += " else {\n" + c + "\n}");
    return d + "\n"
};
Blockly.Java.logic_compare = function() {
    var a = this.getFieldValue("OP"),
        a = Blockly.Java.logic_compare.OPERATORS[a],
        b = "==" == a || "!=" == a ? Blockly.Java.ORDER_EQUALITY : Blockly.Java.ORDER_RELATIONAL,
        c = Blockly.Java.valueToCode(this, "A", b) || "0",
        d = Blockly.Java.valueToCode(this, "B", b) || "0";
    return [c + " " + a + " " + d, b]
};
Blockly.Java.logic_compare.OPERATORS = {
    EQ: "==",
    NEQ: "!=",
    LT: "<",
    LTE: "<=",
    GT: ">",
    GTE: ">="
};
Blockly.Java.logic_operation = function() {
    var a = "AND" == this.getFieldValue("OP") ? "&&" : "||",
        b = "&&" == a ? Blockly.Java.ORDER_LOGICAL_AND : Blockly.Java.ORDER_LOGICAL_OR,
        c = Blockly.Java.valueToCode(this, "A", b) || "false",
        d = Blockly.Java.valueToCode(this, "B", b) || "false";
    return [c + " " + a + " " + d, b]
};
Blockly.Java.logic_negate = function() {
    var a = Blockly.Java.ORDER_UNARY_PREFIX;
    return ["!" + (Blockly.Java.valueToCode(this, "BOOL", a) || "false"), a]
};
Blockly.Java.logic_boolean = function() {
    return ["TRUE" == this.getFieldValue("BOOL") ? "true" : "false", Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.logic_null = function() {
    return ["NULL", Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.loops = {};
Blockly.Java.controls_repeat_ext = function(a) {
    var b = a.getField("TIMES") ? String(Number(a.getFieldValue("TIMES"))) : Blockly.Java.valueToCode(a, "TIMES", Blockly.Java.ORDER_ASSIGNMENT) || "0",
        c = Blockly.Java.statementToCode(a, "DO"),
        c = Blockly.Java.addLoopTrap(c, a.id);
    a = "";
    var d = Blockly.Java.variableDB_.getDistinctName("count", Blockly.Variables.NAME_TYPE),
        e = b;
    b.match(/^\w+$/) || Blockly.isNumber(b) || (e = Blockly.Java.variableDB_.getDistinctName("repeat_end", Blockly.Variables.NAME_TYPE), a += "var " + e + " = " + b + ";\n");
    return a + ("for (int " + d + " = 0; " + d + " < " + e + "; " + d + "++) {\n" + c + "}\n")
};
Blockly.Java.controls_repeat = Blockly.Java.controls_repeat_ext;
Blockly.Java.controls_whileUntil = function(a) {
    var b = "UNTIL" == a.getFieldValue("MODE"),
        c = Blockly.Java.valueToCode(a, "BOOL", b ? Blockly.Java.ORDER_LOGICAL_NOT : Blockly.Java.ORDER_NONE) || "false",
        d = Blockly.Java.statementToCode(a, "DO"),
        d = Blockly.Java.addLoopTrap(d, a.id);
    b && (c = "!" + c);
    return "while (" + c + ") {\n" + d + "}\n"
};
Blockly.Java.controls_for = function(a) {
    var b = Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE),
        c = Blockly.Java.valueToCode(a, "FROM", Blockly.Java.ORDER_ASSIGNMENT) || "0",
        d = Blockly.Java.valueToCode(a, "TO", Blockly.Java.ORDER_ASSIGNMENT) || "0",
        e = Blockly.Java.valueToCode(a, "BY", Blockly.Java.ORDER_ASSIGNMENT) || "1",
        f = Blockly.Java.statementToCode(a, "DO"),
        f = Blockly.Java.addLoopTrap(f, a.id);
    if (Blockly.isNumber(c) && Blockly.isNumber(d) && Blockly.isNumber(e)) {
        var g = parseFloat(c) <=
            parseFloat(d);
        a = "for (" + b + " = " + c + "; " + b + (g ? " <= " : " >= ") + d + "; " + b;
        b = Math.abs(parseFloat(e));
        a = (1 == b ? a + (g ? "++" : "--") : a + ((g ? " += " : " -= ") + b)) + (") {\n" + f + "}\n")
    } else a = "", g = c, c.match(/^\w+$/) || Blockly.isNumber(c) || (g = Blockly.Java.variableDB_.getDistinctName(b + "_start", Blockly.Variables.NAME_TYPE), a += "var " + g + " = " + c + ";\n"), c = d, d.match(/^\w+$/) || Blockly.isNumber(d) || (c = Blockly.Java.variableDB_.getDistinctName(b + "_end", Blockly.Variables.NAME_TYPE), a += "var " + c + " = " + d + ";\n"), d = Blockly.Java.variableDB_.getDistinctName(b +
        "_inc", Blockly.Variables.NAME_TYPE), a += "var " + d + " = ", a = Blockly.isNumber(e) ? a + (Math.abs(e) + ";\n") : a + ("Math.abs(" + e + ");\n"), a += "if (" + g + " > " + c + ") {\n", a += Blockly.Java.INDENT + d + " = -" + d + ";\n", a += "}\n", a += "for (" + b + " = " + g + ";\n     " + d + " >= 0 ? " + b + " <= " + c + " : " + b + " >= " + c + ";\n     " + b + " += " + d + ") {\n" + f + "}\n";
    return a
};
Blockly.Java.controls_forEach = function(a) {
    var b = Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE),
        c = Blockly.Java.valueToCode(a, "LIST", Blockly.Java.ORDER_ASSIGNMENT) || "[]",
        d = Blockly.Java.statementToCode(a, "DO"),
        d = Blockly.Java.addLoopTrap(d, a.id);
    a = "";
    var e = c;
    c.match(/^\w+$/) || (e = Blockly.Java.variableDB_.getDistinctName(b + "_list", Blockly.Variables.NAME_TYPE), a += "var " + e + " = " + c + ";\n");
    c = Blockly.Java.variableDB_.getDistinctName(b + "_index", Blockly.Variables.NAME_TYPE);
    d = Blockly.Java.INDENT + b + " = " + e + "[" + c + "];\n" + d;
    return a + ("for (var " + c + " in " + e + ") {\n" + d + "}\n")
};
Blockly.Java.controls_flow_statements = function(a) {
    switch (a.getFieldValue("FLOW")) {
        case "BREAK":
            return "break;\n";
        case "CONTINUE":
            return "continue;\n"
    }
    throw "Unknown flow statement.";
};
Blockly.Java.math = {};
Blockly.Java.math_number = function(a) {
    return [parseFloat(a.getFieldValue("NUM")), Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.math_arithmetic = function(a) {
    var b = {
            ADD: [" + ", Blockly.Java.ORDER_ADDITION],
            MINUS: [" - ", Blockly.Java.ORDER_SUBTRACTION],
            MULTIPLY: [" * ", Blockly.Java.ORDER_MULTIPLICATION],
            DIVIDE: [" / ", Blockly.Java.ORDER_DIVISION],
            POWER: [null, Blockly.Java.ORDER_COMMA]
        }[a.getFieldValue("OP")],
        c = b[0],
        b = b[1],
        d = Blockly.Java.valueToCode(a, "A", b) || "0";
    a = Blockly.Java.valueToCode(a, "B", b) || "0";
    return c ? [d + c + a, b] : ["Math.pow(" + d + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.math_single = function(a) {
    var b = a.getFieldValue("OP"),
        c;
    if ("NEG" == b) return a = Blockly.Java.valueToCode(a, "NUM", Blockly.Java.ORDER_UNARY_NEGATION) || "0", "-" == a[0] && (a = " " + a), ["-" + a, Blockly.Java.ORDER_UNARY_NEGATION];
    a = "SIN" == b || "COS" == b || "TAN" == b ? Blockly.Java.valueToCode(a, "NUM", Blockly.Java.ORDER_DIVISION) || "0" : Blockly.Java.valueToCode(a, "NUM", Blockly.Java.ORDER_NONE) || "0";
    switch (b) {
        case "ABS":
            c = "Math.abs(" + a + ")";
            break;
        case "ROOT":
            c = "Math.sqrt(" + a + ")";
            break;
        case "LN":
            c = "Math.log(" + a + ")";
            break;
        case "EXP":
            c = "Math.exp(" + a + ")";
            break;
        case "POW10":
            c = "Math.pow(10," + a + ")";
            break;
        case "ROUND":
            c = "Math.round(" + a + ")";
            break;
        case "ROUNDUP":
            c = "Math.ceil(" + a + ")";
            break;
        case "ROUNDDOWN":
            c = "Math.floor(" + a + ")";
            break;
        case "SIN":
            c = "Math.sin(" + a + " / 180 * Math.PI)";
            break;
        case "COS":
            c = "Math.cos(" + a + " / 180 * Math.PI)";
            break;
        case "TAN":
            c = "Math.tan(" + a + " / 180 * Math.PI)"
    }
    if (c) return [c, Blockly.Java.ORDER_FUNCTION_CALL];
    switch (b) {
        case "LOG10":
            c = "Math.log(" + a + ") / Math.log(10)";
            break;
        case "ASIN":
            c = "Math.asin(" +
                a + ") / Math.PI * 180";
            break;
        case "ACOS":
            c = "Math.acos(" + a + ") / Math.PI * 180";
            break;
        case "ATAN":
            c = "Math.atan(" + a + ") / Math.PI * 180";
            break;
        default:
            throw "Unknown math operator: " + b;
    }
    return [c, Blockly.Java.ORDER_DIVISION]
};
Blockly.Java.math_constant = function(a) {
    return {
        PI: ["Math.PI", Blockly.Java.ORDER_MEMBER],
        E: ["Math.E", Blockly.Java.ORDER_MEMBER],
        GOLDEN_RATIO: ["(1 + Math.sqrt(5)) / 2", Blockly.Java.ORDER_DIVISION],
        SQRT2: ["Math.sqrt(2)", Blockly.Java.ORDER_MEMBER],
        SQRT1_2: ["Math.sqrt(1/2)", Blockly.Java.ORDER_MEMBER],
        INFINITY: ["Double.POSITIVE_INFINITY", Blockly.Java.ORDER_ATOMIC]
    }[a.getFieldValue("CONSTANT")]
};
Blockly.Java.math_number_property = function(a) {
    var b = Blockly.Java.valueToCode(a, "NUMBER_TO_CHECK", Blockly.Java.ORDER_MODULUS) || "0",
        c = a.getFieldValue("PROPERTY"),
        d;
    if ("PRIME" == c) return [Blockly.Java.provideFunction_("math_isPrime", ["boolean " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(int n) {", "  for(int i = 2; i < n; i++){", "    if(n % i == 0) return false;", "  }", "  return true;", "}"]) + "(" + b + ")", Blockly.Java.ORDER_FUNCTION_CALL];
    switch (c) {
        case "EVEN":
            d = b + " % 2 == 0";
            break;
        case "ODD":
            d = b + " % 2 == 1";
            break;
        case "WHOLE":
            d = b + " % 1 == 0";
            break;
        case "POSITIVE":
            d = b + " > 0";
            break;
        case "NEGATIVE":
            d = b + " < 0";
            break;
        case "DIVISIBLE_BY":
            a = Blockly.Java.valueToCode(a, "DIVISOR", Blockly.Java.ORDER_MODULUS) || "0", d = b + " % " + a + " == 0"
    }
    return [d, Blockly.Java.ORDER_EQUALITY]
};
Blockly.Java.math_change = function(a) {
    var b = Blockly.Java.valueToCode(a, "DELTA", Blockly.Java.ORDER_ADDITION) || "0";
    a = Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE);
    return a + " = (typeof(" + a + ") == 'number' ? " + a + " : 0) + " + b + ";\n"
};
Blockly.Java.math_round = Blockly.Java.math_single;
Blockly.Java.math_trig = Blockly.Java.math_single;
Blockly.Java.math_modulo = function(a) {
    var b = Blockly.Java.valueToCode(a, "DIVIDEND", Blockly.Java.ORDER_MODULUS) || "0";
    a = Blockly.Java.valueToCode(a, "DIVISOR", Blockly.Java.ORDER_MODULUS) || "0";
    return [b + " % " + a, Blockly.Java.ORDER_MODULUS]
};
Blockly.Java.math_constrain = function(a) {
    var b = Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_COMMA) || "0",
        c = Blockly.Java.valueToCode(a, "LOW", Blockly.Java.ORDER_COMMA) || "0";
    a = Blockly.Java.valueToCode(a, "HIGH", Blockly.Java.ORDER_COMMA) || "Infinity";
    return ["Math.min(Math.max(" + b + ", " + c + "), " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.math_random_int = function(a) {
    var b = Blockly.Java.valueToCode(a, "FROM", Blockly.Java.ORDER_COMMA) || "0";
    a = Blockly.Java.valueToCode(a, "TO", Blockly.Java.ORDER_COMMA) || "0";
    return [Blockly.Java.provideFunction_("math_random_int", ["int " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(min, max) {", "  return new Random().nextInt((max - min) + 1) + min;", "}"]) + "(" + b + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.math_random_float = function(a) {
    return ["Math.random()", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.procedures = {};
Blockly.Java.procedures_defreturn = function(a) {
    var b = Blockly.Java.variableDB_.getName(a.getFieldValue("NAME"), Blockly.Procedures.NAME_TYPE),
        c = Blockly.Java.statementToCode(a, "STACK");
    Blockly.Java.STATEMENT_PREFIX && (c = Blockly.Java.prefixLines(Blockly.Java.STATEMENT_PREFIX.replace(/%1/g, "'" + a.id + "'"), Blockly.Java.INDENT) + c);
    Blockly.Java.INFINITE_LOOP_TRAP && (c = Blockly.Java.INFINITE_LOOP_TRAP.replace(/%1/g, "'" + a.id + "'") + c);
    var d = Blockly.Java.valueToCode(a, "RETURN", Blockly.Java.ORDER_NONE) || "";
    d && (d = "  return " +
        d + ";\n");
    for (var e = [], f = 0; f < a.arguments_.length; f++) e[f] = Blockly.Java.variableDB_.getName(a.arguments_[f], Blockly.Variables.NAME_TYPE);
    c = "public Object " + b + "(" + e.join(", ") + ") {\n" + c + d + "}";
    c = Blockly.Java.scrub_(a, c);
    Blockly.Java.definitions_[b] = c;
    return null
};
Blockly.Java.procedures_defnoreturn = Blockly.Java.procedures_defreturn;
Blockly.Java.procedures_callreturn = function(a) {
    for (var b = Blockly.Java.variableDB_.getName(a.getFieldValue("NAME"), Blockly.Procedures.NAME_TYPE), c = [], d = 0; d < a.arguments_.length; d++) c[d] = Blockly.Java.valueToCode(a, "ARG" + d, Blockly.Java.ORDER_COMMA) || "null";
    return ["public void " + b + "(" + c.join(", ") + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.procedures_callnoreturn = function(a) {
    for (var b = Blockly.Java.variableDB_.getName(a.getFieldValue("NAME"), Blockly.Procedures.NAME_TYPE), c = [], d = 0; d < a.arguments_.length; d++) c[d] = Blockly.Java.valueToCode(a, "ARG" + d, Blockly.Java.ORDER_COMMA) || "null";
    return b + "(" + c.join(", ") + ");\n"
};
Blockly.Java.procedures_ifreturn = function(a) {
    var b = "if (" + (Blockly.Java.valueToCode(a, "CONDITION", Blockly.Java.ORDER_NONE) || "false") + ") {\n";
    a.hasReturnValue_ ? (a = Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_NONE) || "null", b += "  return " + a + ";\n") : b += "  return;\n";
    return b + "}\n"
};
Blockly.Java.texts = {};
Blockly.Java.text = function(a) {
    return [Blockly.Java.quote_(a.getFieldValue("TEXT")), Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.text_join = function(a) {
    var b;
    if (0 == a.itemCount_) return ['""', Blockly.Java.ORDER_ATOMIC];
    if (1 == a.itemCount_) return [Blockly.Java.valueToCode(a, "ADD0", Blockly.Java.ORDER_NONE) || '"', Blockly.Java.ORDER_FUNCTION_CALL];
    b = Array(a.itemCount_);
    for (var c = 0; c < a.itemCount_; c++) b[c] = Blockly.Java.valueToCode(a, "ADD" + c, Blockly.Java.ORDER_COMMA) || '"';
    b = b.join("+");
    return [b, Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.text_append = function(a) {
    var b = Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE);
    a = Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_NONE) || "''";
    return b + " = String(" + b + ") + String(" + a + ");\n"
};
Blockly.Java.text_length = function(a) {
    return [(Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_FUNCTION_CALL) || "''") + ".length()", Blockly.Java.ORDER_MEMBER]
};
Blockly.Java.text_isEmpty = function(a) {
    return [(Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "''") + ".isEmpty()", Blockly.Java.ORDER_LOGICAL_NOT]
};
Blockly.Java.text_indexOf = function(a) {
    var b = "FIRST" == a.getFieldValue("END") ? "indexOf" : "lastIndexOf",
        c = Blockly.Java.valueToCode(a, "FIND", Blockly.Java.ORDER_NONE) || "''";
    return [(Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "''") + "." + b + "(" + c + ") + 1", Blockly.Java.ORDER_MEMBER]
};
Blockly.Java.text_charAt = function(a) {
    var b = a.getFieldValue("WHERE") || "FROM_START",
        c = Blockly.Java.valueToCode(a, "AT", Blockly.Java.ORDER_UNARY_NEGATION) || "1";
    a = Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_MEMBER) || "''";
    switch (b) {
        case "FIRST":
            return [a + ".charAt(0)", Blockly.Java.ORDER_FUNCTION_CALL];
        case "LAST":
            return [a + ".charAt(" + a + ".length() -1)", Blockly.Java.ORDER_FUNCTION_CALL];
        case "FROM_START":
            return c = Blockly.isNumber(c) ? parseFloat(c) - 1 : c + " - 1", [a + ".charAt(" + c + ")", Blockly.Java.ORDER_FUNCTION_CALL];
        case "FROM_END":
            return [a + ".charAt(" + a + ".length()-" + c + ")", Blockly.Java.ORDER_FUNCTION_CALL];
        case "RANDOM":
            return [Blockly.Java.provideFunction_("text_random_letter", ["function " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(text) {", "  var x = Math.floor(Math.random() * text.length);", "  return text[x];", "}"]) + "(" + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
    }
    throw "Unhandled option (text_charAt).";
};
Blockly.Java.text_getSubstring = function(a) {
    var b = Blockly.Java.valueToCode(a, "STRING", Blockly.Java.ORDER_MEMBER) || "''",
        c = a.getFieldValue("WHERE1"),
        d = a.getFieldValue("WHERE2"),
        e = Blockly.Java.valueToCode(a, "AT1", Blockly.Java.ORDER_NONE) || "1";
    a = Blockly.Java.valueToCode(a, "AT2", Blockly.Java.ORDER_NONE) || "1";
    return ["FIRST" == c && "LAST" == d ? b : b + ".substring(" + e + ", " + a + ")", Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.text_changeCase = function(a) {
    var b = {
        UPPERCASE: ".toUpperCase()",
        LOWERCASE: ".toLowerCase()",
        TITLECASE: null
    }[a.getFieldValue("CASE")];
    b ? (a = Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_MEMBER) || "''", b = a + b) : (Blockly.Java.provideFunction_("text_toTitleCase", ["function " + Blockly.Java.FUNCTION_NAME_PLACEHOLDER_ + "(str) {", "  return str.replace(/\\S+/g,", "      function(txt) {return txt[0].toUpperCase() + txt.substring(1).toLowerCase();});", "}"]), a = Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_NONE) ||
        "''", b = a + ".charAt(0) + " + a + ".substring(1," + a + ".length() -1).toLowerCase()", asdf.substring(1, asdf.length() - 1));
    return [b, Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.text_trim = function(a) {
    var b = {
        LEFT: '.replaceAll("^\\s+", "")',
        RIGHT: '.replaceAll("\\s+$", "")',
        BOTH: ".trim()"
    }[a.getFieldValue("MODE")];
    return [(Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_MEMBER) || "''") + b, Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.text_print = function(a) {
    return "System.out.println(" + (Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_NONE) || "''") + ");\n"
};
Blockly.Java.text_prompt_ext = function(a) {
    var b = "System.out.println(" + (a.getField("TEXT") ? Blockly.Java.quote_(a.getFieldValue("TEXT")) : Blockly.Java.valueToCode(a, "TEXT", Blockly.Java.ORDER_NONE) || "''") + ")";
    "NUMBER" == a.getFieldValue("TYPE") && (b = "parseFloat(" + b + ")");
    return [b, Blockly.Java.ORDER_FUNCTION_CALL]
};
Blockly.Java.text_prompt = Blockly.Java.text_prompt_ext;
Blockly.Java.variables = {};
Blockly.Java.variables_get = function(a) {
    return [Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE), Blockly.Java.ORDER_ATOMIC]
};
Blockly.Java.variables_set = function(a) {
    var b = Blockly.Java.valueToCode(a, "VALUE", Blockly.Java.ORDER_ASSIGNMENT) || "0";
    return Blockly.Java.variableDB_.getName(a.getFieldValue("VAR"), Blockly.Variables.NAME_TYPE) + " = " + b + ";\n"
};