var convertToJSON = function(data, origin) {
  return (origin == 'cloc') ? convertFromClocToJSON(data) : convertFromWcToJSON(data);
};

/**
 * Convert the output of cloc in csv to JSON format
 *
 *  > cloc . --csv --exclude-dir=vendor,tmp --by-file --report-file=data.cloc
 */
var convertFromClocToJSON = function(data) {
  var lines = data.split("\n");
  lines.shift(); // drop the header line

  var json = {};
  lines.forEach(function(line) {
    var cols = line.split(',');
    var filename = cols[1];
    if (!filename) return;
    var elements = filename.split(/[\/\\]/);
    var current = json;
    elements.forEach(function(element) {
      if (!current[element]) {
        current[element] = {};
      }
      current = current[element];
    });
    current.language = cols[0];
    current.size = parseInt(cols[4], 10);
  });

  json = getChildren(json)[0];
  json.name = 'root';

  return json;
};

/**
 * Convert the output of wc to JSON format
 *
 *  > git ls-files | xargs wc -l
 */
var convertFromWcToJSON = function(data) {
  var lines = data.split("\n");

  var json = {};
  var filename, size, cols, elements, current;
  lines.forEach(function(line) {
      cols = line.trim().split(' ');
      size = parseInt(cols[0], 10);
      if (!size) return;
      filename = cols[1];
      if (filename === "total") return;
      if (!filename) return;
      elements = filename.split(/[\/\\]/);
      current = json;
      elements.forEach(function(element) {
          if (!current[element]) {
              current[element] = {};
          }
          current = current[element];
      });
      current.size = size;
  });

  json.children = getChildren(json);
  json.name = 'root';

  return json;
};

/**
 * Convert a simple json object into another specifying children as an array
 * Works recursively
 *
 * example input:
 * { a: { b: { c: { size: 12 }, d: { size: 34 } }, e: { size: 56 } } }
 * example output
 * { name: a, children: [
 *   { name: b, children: [
 *     { name: c, size: 12 },
 *     { name: d, size: 34 }
 *   ] },
 *   { name: e, size: 56 }
 * ] } }
 */
var getChildren = function(json) {
  var children = [];
  if (json.language) return children;
  for (var key in json) {
    var child = { name: key };
    if (json[key].size) {
      // value node
      child.size = json[key].size;
      child.language = json[key].language;
    } else {
      // children node
      var childChildren = getChildren(json[key]);
      if (childChildren) child.children = childChildren;
    }
    children.push(child);
    delete json[key];
  }
  return children;
};

// Recursively count all elements in a tree
var countElements = function(node) {
  var nbElements = 1;
  if (node.children) {
    nbElements += node.children.reduce(function(p, v) { return p + countElements(v); }, 0);
  }
  return nbElements;
};
