/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.collection.SetCover;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.core.Resource;
import java.util.Objects;
import java.util.Set;

public class Collection {
    private final SetCover<Resource> resources = new SetCover();
    private final SetCover<Link> links = new SetCover();
    private final SetCover<ActionInstance> actions = new SetCover();
    private Model model;

    public boolean containsResource(Resource resource) {
        return this.resources.contains(resource);
    }

    public boolean containsResource(String resourceIdentifier) {
        return this.resources.contains(resourceIdentifier);
    }

    public boolean addResource(Resource resource) {
        return this.resources.add(resource);
    }

    public Resource getResource(String resourceIdentifier) {
        return this.resources.get(resourceIdentifier);
    }

    public boolean removeResource(Resource resource) {
        return this.resources.remove(resource);
    }

    public void clearResources() {
        this.resources.clear();
    }

    public Set<Resource> getResources() {
        return this.resources.getSet();
    }

    public boolean containsLink(Link link) {
        return this.links.contains(link);
    }

    public boolean containsLink(String linkIdentifier) {
        return this.links.contains(linkIdentifier);
    }

    public boolean addLink(Link link) {
        return this.links.add(link);
    }

    public Link getLink(String linkIdentifier) {
        return this.links.get(linkIdentifier);
    }

    public boolean removeLink(Link link) {
        return this.links.remove(link);
    }

    public void clearLinks() {
        this.links.clear();
    }

    public Set<Link> getLinks() {
        return this.links.getSet();
    }

    public boolean containsAction(ActionInstance action) {
        return this.actions.contains(action);
    }

    public boolean containsAction(String actionIdentifier) {
        return this.actions.contains(actionIdentifier);
    }

    public boolean addAction(ActionInstance action) {
        return this.actions.add(action);
    }

    public ActionInstance getAction(String actionIdentifier) {
        return this.actions.get(actionIdentifier);
    }

    public boolean removeAction(ActionInstance action) {
        return this.actions.remove(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public Set<ActionInstance> getActions() {
        return this.actions.getSet();
    }

    public void merge(Collection collection) {
        this.resources.addAll(collection.getResources());
        this.links.addAll(collection.getLinks());
        this.actions.addAll(collection.getActions());
    }

    public void setModel(Model model) {
        this.model = model;
        for (Link link : this.links.getSet(true)) {
            link.setModel(model);
        }
        for (Resource resource : this.resources.getSet(true)) {
            resource.setModel(model);
        }
        for (ActionInstance ai : this.actions.getSet(true)) {
            ai.setModel(model);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Objects.hashCode(this.resources);
        hash = 41 * hash + Objects.hashCode(this.links);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Collection other = (Collection)obj;
        if (!Objects.equals(this.resources, other.resources)) {
            return false;
        }
        if (!Objects.equals(this.links, other.links)) {
            return false;
        }
        return Objects.equals(this.actions, other.actions);
    }

    public String toString() {
        return "Collection{resources=" + this.resources + ", links=" + this.links + ", model=" + this.model + '}';
    }
}

