/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import cz.cesnet.cloud.occi.renderer.TextRenderer;
import cz.cesnet.cloud.occi.type.Identifiable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute
implements Identifiable,
Comparable<Attribute> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Attribute.class);
    private String name;
    private boolean required;
    private boolean immutable;
    private String type;
    private String pattern;
    private String defaultValue;
    private String description;

    public Attribute(String name, boolean required, boolean immutable, String type, String pattern, String defaultValue, String description) {
        LOGGER.debug("Creating attribute: name={}, required={}, immutable={}, type={}, pattern={}, defaultValue={}, description={}", new Object[]{name, required, immutable, type, pattern, defaultValue, description});
        if (name == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty.");
        }
        this.name = name;
        this.required = required;
        this.immutable = immutable;
        this.type = type;
        this.pattern = pattern == null ? ".*" : pattern;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public Attribute(String name, boolean required, boolean immutable) {
        this(name, required, immutable, null, null, null, null);
    }

    public Attribute(String name) {
        this(name, false, false, null, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty.");
        }
        this.name = name;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Attribute{name=" + this.name + ", required=" + this.required + ", immutable=" + this.immutable + ", type=" + this.type + ", pattern=" + this.pattern + ", defaultValue=" + this.defaultValue + ", description=" + this.description + '}';
    }

    public String toText() {
        StringBuilder sb = new StringBuilder(this.name);
        StringBuilder properties = null;
        if (this.required) {
            properties = new StringBuilder("required");
        }
        if (this.immutable) {
            if (properties == null) {
                properties = new StringBuilder("immutable");
            } else {
                properties.append(" immutable");
            }
        }
        if (properties != null) {
            sb.append(TextRenderer.surroundString(properties.toString(), "{", "}"));
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Attribute a) {
        return this.getIdentifier().compareTo(a.getIdentifier());
    }
}

