/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.collection.SetCover;
import cz.cesnet.cloud.occi.core.Action;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.renderer.TextRenderer;
import cz.cesnet.cloud.occi.type.Identifiable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Category
implements Identifiable,
Comparable<Category> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Category.class);
    public static final URI SCHEME_CORE_DEFAULT = URI.create("http://schemas.ogf.org/occi/core#");
    public static final URI SCHEME_INFRASTRUCTURE_DEFAULT = URI.create("http://schemas.ogf.org/occi/infrastructure#");
    private String term;
    private URI scheme;
    private String title;
    private URI location;
    private final SetCover<Attribute> attributes = new SetCover();
    private final SetCover<Action> actions = new SetCover();
    private final SetCover<Entity> entities = new SetCover();

    public Category(URI scheme, String term, String title, URI location, Collection<Attribute> attributes) {
        LOGGER.debug("Creating category: scheme={}, term={}, title={}, location={}, attributes={}", new Object[]{scheme, term, title, location, attributes});
        if (scheme == null) {
            throw new NullPointerException("Category scheme cannot be null.");
        }
        if (term == null) {
            throw new NullPointerException("Category term cannot be null.");
        }
        if (term.isEmpty()) {
            throw new IllegalArgumentException("Category term cannot be empty.");
        }
        this.scheme = scheme;
        this.term = term;
        this.title = title;
        this.location = location;
        if (attributes != null) {
            this.attributes.addAll(attributes);
        }
    }

    public Category(URI scheme, String term) {
        this(scheme, term, null, null, null);
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        if (term == null) {
            throw new NullPointerException("Category term cannot be null.");
        }
        if (term.isEmpty()) {
            throw new IllegalArgumentException("Category term cannot be empty.");
        }
        this.term = term;
    }

    public URI getScheme() {
        return this.scheme;
    }

    public void setScheme(URI scheme) {
        if (scheme == null) {
            throw new NullPointerException("Category scheme cannot be null.");
        }
        this.scheme = scheme;
    }

    @Override
    public String getIdentifier() {
        return this.getScheme().toString() + this.getTerm();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.attributes.contains(attribute);
    }

    public boolean containsAttribute(String attributeIdentifier) {
        return this.attributes.contains(attributeIdentifier);
    }

    public boolean addAttribute(Attribute attribute) {
        return this.attributes.add(attribute);
    }

    public Attribute getAttribute(String attributeIdentifier) {
        return this.attributes.get(attributeIdentifier);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Set<Attribute> getAttributes() {
        return this.attributes.getSet();
    }

    public boolean containsAction(Action action) {
        return this.actions.contains(action);
    }

    public boolean containsAction(String actionIdentifier) {
        return this.actions.contains(actionIdentifier);
    }

    public boolean addAction(Action action) {
        return this.actions.add(action);
    }

    public Action getAction(String actionIdentifier) {
        return this.actions.get(actionIdentifier);
    }

    public boolean removeAction(Action action) {
        return this.actions.remove(action);
    }

    public void clearActions() {
        this.actions.clear();
    }

    public Set<Action> getActions() {
        return this.actions.getSet();
    }

    public boolean containsEntity(Entity entity) {
        return this.entities.contains(entity);
    }

    public boolean containsEntity(String entityIdentifier) {
        return this.entities.contains(entityIdentifier);
    }

    public boolean addEntity(Entity entity) {
        return this.entities.add(entity);
    }

    public Entity getEntity(String entityIdentifier) {
        return this.entities.get(entityIdentifier);
    }

    public boolean removeEntity(Entity entity) {
        return this.entities.remove(entity);
    }

    public void clearEntities() {
        this.entities.clear();
    }

    public Set<Entity> getEntities() {
        return this.entities.getSet();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.term);
        hash = 79 * hash + Objects.hashCode(this.scheme);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (!Objects.equals(this.term, other.term)) {
            return false;
        }
        return Objects.equals(this.scheme, other.scheme);
    }

    public String toString() {
        return "Category{term=" + this.term + ", scheme=" + this.scheme + ", title=" + this.title + ", location=" + this.location + ", attributes=" + this.attributes + '}';
    }

    public String toText() {
        return this.toText(true);
    }

    public String toText(boolean fullRendering) {
        StringBuilder sb = new StringBuilder("Category: ");
        sb.append(this.textBody(fullRendering));
        return sb.toString();
    }

    public Headers toHeaders() {
        return this.toHeaders(true);
    }

    public Headers toHeaders(boolean fullRendering) {
        Headers headers = new Headers();
        headers.add("Category", this.textBody(fullRendering));
        return headers;
    }

    private String textBody(boolean fullRendering) {
        StringBuilder sb = new StringBuilder(this.term);
        sb.append(";");
        sb.append("scheme");
        sb.append(TextRenderer.surroundString(this.scheme.toString()));
        sb.append("class");
        sb.append(TextRenderer.surroundString(this.getClass().getSimpleName().toLowerCase()));
        if (fullRendering) {
            Mixin mixin;
            Kind kind;
            if (this.title != null && !this.title.isEmpty()) {
                sb.append("title");
                sb.append(TextRenderer.surroundString(this.title));
            }
            if (this instanceof Kind && (kind = (Kind)this).getRelations().size() == 1) {
                sb.append("rel");
                for (Kind k : kind.getRelations()) {
                    sb.append(TextRenderer.surroundString(k.getIdentifier()));
                }
            }
            if (this instanceof Mixin && (mixin = (Mixin)this).getRelations().size() == 1) {
                sb.append("rel");
                for (Mixin m : mixin.getRelations()) {
                    sb.append(TextRenderer.surroundString(m.getIdentifier()));
                }
            }
            if (this.location != null) {
                sb.append("location");
                sb.append(TextRenderer.surroundString(this.location.toString()));
            }
            if (this.attributes != null && !this.attributes.getSet().isEmpty()) {
                sb.append("attributes");
                StringBuilder attrSB = new StringBuilder();
                ArrayList<Attribute> attributeList = new ArrayList<Attribute>(this.attributes.getSet());
                Collections.sort(attributeList);
                for (Attribute attribute : attributeList) {
                    attrSB.append(attribute.toText());
                    attrSB.append(" ");
                }
                attrSB.deleteCharAt(attrSB.length() - 1);
                sb.append(TextRenderer.surroundString(attrSB.toString()));
            }
            if (this.actions != null && !this.actions.getSet().isEmpty()) {
                sb.append("actions");
                StringBuilder actionsSB = new StringBuilder();
                ArrayList<Action> actionList = new ArrayList<Action>(this.actions.getSet());
                Collections.sort(actionList);
                for (Action action : actionList) {
                    actionsSB.append(action.getIdentifier());
                    actionsSB.append(" ");
                }
                actionsSB.deleteCharAt(actionsSB.length() - 1);
                sb.append(TextRenderer.surroundString(actionsSB.toString()));
            }
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Category c) {
        return this.getIdentifier().compareTo(c.getIdentifier());
    }
}

