/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.core;

import com.sun.net.httpserver.Headers;
import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.collection.AttributeMapCover;
import cz.cesnet.cloud.occi.collection.SetCover;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import cz.cesnet.cloud.occi.type.Identifiable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Entity
implements Identifiable,
Comparable<Entity> {
    public static final String ID_ATTRIBUTE_NAME = "occi.core.id";
    public static final String TITLE_ATTRIBUTE_NAME = "occi.core.title";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_CORE_DEFAULT;
    public static final String TERM_DEFAULT = "entity";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "entity";
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity.class);
    private Kind kind;
    private Model model;
    private final SetCover<Mixin> mixins = new SetCover();
    private final AttributeMapCover attributes = new AttributeMapCover();

    public Entity(String id, Kind kind, String title, Model model) throws InvalidAttributeValueException {
        LOGGER.debug("Creating Entity: class={}, id={}, kind={}, title={}, model={}", new Object[]{this.getClass().getName(), id, kind, title, model});
        if (id == null) {
            throw new NullPointerException("Entity id cannot be null.");
        }
        if (kind == null) {
            throw new NullPointerException("Entity kind cannot be null.");
        }
        this.privateAddAttribute(ID_ATTRIBUTE_NAME, id);
        if (title != null && !title.isEmpty()) {
            this.privateAddAttribute(TITLE_ATTRIBUTE_NAME, title);
        }
        this.kind = kind;
        this.model = model;
    }

    public Entity(String id, Kind kind) throws InvalidAttributeValueException {
        this(id, kind, null, null);
    }

    public String getId() {
        return this.getValue(ID_ATTRIBUTE_NAME);
    }

    public void setId(String id) throws InvalidAttributeValueException {
        if (id == null) {
            throw new NullPointerException("Entity id cannot be null.");
        }
        this.addAttribute(ID_ATTRIBUTE_NAME, id);
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        if (kind == null) {
            throw new NullPointerException("Entity kind cannot be null.");
        }
        this.kind = kind;
    }

    @Override
    public String getIdentifier() {
        return this.kind.getIdentifier() + "|" + this.getId();
    }

    public String getTitle() {
        return this.getValue(TITLE_ATTRIBUTE_NAME);
    }

    public void setTitle(String title) throws InvalidAttributeValueException {
        this.addAttribute(TITLE_ATTRIBUTE_NAME, title);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    private void privateAddAttribute(String attributeIdentifier, String value) throws InvalidAttributeValueException {
        if (!this.isValidAttributeValue(attributeIdentifier, value)) {
            Attribute attribute = this.getAttribute(attributeIdentifier);
            throw new InvalidAttributeValueException("'" + value + "' is not a suitable value for " + attribute);
        }
        Attribute attribute = this.getAttribute(attributeIdentifier);
        if (attribute == null) {
            attribute = new Attribute(attributeIdentifier);
        }
        this.attributes.add(attribute, value);
    }

    public void addAttribute(String attributeIdentifier, String value) throws InvalidAttributeValueException {
        this.privateAddAttribute(attributeIdentifier, value);
    }

    public void addAttributes(Map<String, String> attributes) throws InvalidAttributeValueException {
        for (String name : attributes.keySet()) {
            this.privateAddAttribute(name, attributes.get(name));
        }
    }

    private boolean isValidAttributeValue(String attributeIdentifier, String value) {
        Attribute attribute = this.getAttribute(attributeIdentifier);
        if (attribute == null) {
            return true;
        }
        if (attribute.getPattern() == null || attribute.getPattern().isEmpty()) {
            return true;
        }
        return value.matches(attribute.getPattern());
    }

    private Attribute getAttribute(String attributeIdentifier) {
        Attribute attribute = this.getAttributeFromKindsIfExists(this.kind, attributeIdentifier);
        if (attribute == null) {
            attribute = this.getAttributeFromMixinsIfExists(this.getMixins(), attributeIdentifier);
        }
        return attribute;
    }

    private Attribute getAttributeFromKindsIfExists(Kind kind, String attributeIdentifier) {
        if (kind == null) {
            return null;
        }
        if (kind.containsAttribute(attributeIdentifier)) {
            return kind.getAttribute(attributeIdentifier);
        }
        Attribute attribute = null;
        for (Kind k : kind.getRelations()) {
            if (attribute != null) {
                return attribute;
            }
            attribute = this.getAttributeFromKindsIfExists(k, attributeIdentifier);
        }
        return attribute;
    }

    private Attribute getAttributeFromMixinsIfExists(Set<Mixin> mixins, String attributeIdentifier) {
        for (Mixin m : mixins) {
            if (m.containsAttribute(attributeIdentifier)) {
                return m.getAttribute(attributeIdentifier);
            }
            Attribute attribute = this.getAttributeFromMixinsIfExists(m.getRelations(), attributeIdentifier);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public void removeAttribute(String attributeIdentifier) {
        this.attributes.remove(attributeIdentifier);
    }

    public boolean containsAttribute(Attribute attribute) {
        return this.attributes.containsAttribute(attribute);
    }

    public boolean containsAttribute(String attributeName) {
        return this.attributes.containsAttribute(attributeName);
    }

    public String getValue(Attribute attribute) {
        return this.attributes.getValue(attribute);
    }

    public String getValue(String attributeName) {
        return this.attributes.getValue(attributeName);
    }

    public Map<Attribute, String> getAttributes() {
        return this.attributes.getAttributes();
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    protected String attributesToOneLineText() {
        return this.attributes.toOneLineText();
    }

    protected String attributesToPrefixText() {
        return this.attributes.toPrefixText();
    }

    protected Headers attributesToHeaders() {
        return this.attributes.toHeaders();
    }

    public boolean containsMixin(Mixin mixin) {
        return this.mixins.contains(mixin);
    }

    public boolean containsMixin(String mixinIdentifier) {
        return this.mixins.contains(mixinIdentifier);
    }

    public boolean addMixin(Mixin mixin) {
        return this.mixins.add(mixin);
    }

    public boolean addMixins(Collection<Mixin> mixins) {
        return this.mixins.addAll(mixins);
    }

    public Mixin getMixin(String mixinIdentifier) {
        return this.mixins.get(mixinIdentifier);
    }

    public boolean removeMixin(Mixin mixin) {
        return this.mixins.remove(mixin);
    }

    public void clearMixins() {
        this.mixins.clear();
    }

    public Set<Mixin> getMixins() {
        return this.mixins.getSet();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getId());
        hash = 89 * hash + Objects.hashCode(this.kind);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!Objects.equals(this.getId(), other.getId())) {
            return false;
        }
        return Objects.equals(this.kind, other.kind);
    }

    public String toString() {
        return "Entity{class=" + this.getClass().getName() + ", id=" + this.getId() + ", kind=" + this.kind + ", title=" + this.getTitle() + ", mixins=" + this.mixins + ", attributes=" + this.attributes + '}';
    }

    public abstract String toText() throws RenderingException;

    public abstract Headers toHeaders() throws RenderingException;

    public abstract String toJSON();

    @Override
    public int compareTo(Entity e) {
        return this.getIdentifier().compareTo(e.getIdentifier());
    }

    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.add(new Attribute(ID_ATTRIBUTE_NAME, true, true));
        list.add(new Attribute(TITLE_ATTRIBUTE_NAME, false, false));
        return list;
    }
}

