/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.enumeration.StorageState;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Storage
extends Resource {
    public static final String SIZE_ATTRIBUTE_NAME = "occi.storage.size";
    public static final String STATE_ATTRIBUTE_NAME = "occi.storage.state";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    public static final String TERM_DEFAULT = "storage";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "storage";

    public Storage(String id, Kind kind, String title, Model model, String summary) throws InvalidAttributeValueException {
        super(id, kind, title, model, summary);
    }

    public Storage(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getSize() {
        return this.getValue(SIZE_ATTRIBUTE_NAME);
    }

    public void setSize(float size) throws InvalidAttributeValueException {
        this.addAttribute(SIZE_ATTRIBUTE_NAME, String.valueOf(size));
    }

    public void setSize(String size) throws InvalidAttributeValueException {
        this.addAttribute(SIZE_ATTRIBUTE_NAME, size);
    }

    public String getState() {
        return this.getValue(STATE_ATTRIBUTE_NAME);
    }

    public void setState(StorageState state) throws InvalidAttributeValueException {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.addAttribute(STATE_ATTRIBUTE_NAME, state.toString());
    }

    public void setState(String stateName) throws InvalidAttributeValueException {
        this.addAttribute(STATE_ATTRIBUTE_NAME, stateName);
    }

    public static URI getSchemeDefault() {
        return Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    }

    public static String getTermDefault() {
        return TERM_DEFAULT;
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Resource.getDefaultAttributes());
        list.add(new Attribute(SIZE_ATTRIBUTE_NAME, true, false));
        list.add(new Attribute(STATE_ATTRIBUTE_NAME, true, true));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Storage Resource", URI.create("/storage/"), Storage.getDefaultAttributes());
        return kind;
    }
}

