/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb;

import cz.etnetera.seb.SebContext;
import java.util.function.Consumer;
import org.openqa.selenium.JavascriptExecutor;

public class SebAlert {
    protected SebContext context;

    public SebAlert(SebContext context) {
        this.context = context;
    }

    public void acceptAlertDialog(Consumer<SebContext> showDialog) {
        boolean supportsAlerts = this.isAlertSupported();
        if (!supportsAlerts) {
            ((JavascriptExecutor)this.context.getDriver()).executeScript("window.alert = function(msg){};", new Object[0]);
        }
        showDialog.accept(this.context);
        if (supportsAlerts) {
            this.context.getDriver().switchTo().alert().accept();
        }
    }

    public void acceptConfirmDialog(Consumer<SebContext> showDialog) {
        boolean supportsAlerts = this.isAlertSupported();
        if (!supportsAlerts) {
            ((JavascriptExecutor)this.context.getDriver()).executeScript("window.confirm = function(msg){return true;};", new Object[0]);
        }
        showDialog.accept(this.context);
        if (supportsAlerts) {
            this.context.getDriver().switchTo().alert().accept();
        }
    }

    public void dismissConfirmDialog(Consumer<SebContext> showDialog) {
        boolean supportsAlerts = this.isAlertSupported();
        if (!supportsAlerts) {
            ((JavascriptExecutor)this.context.getDriver()).executeScript("window.confirm = function(msg){return false;};", new Object[0]);
        }
        showDialog.accept(this.context);
        if (supportsAlerts) {
            this.context.getDriver().switchTo().alert().dismiss();
        }
    }

    public boolean isAlertSupported() {
        return this.context.getSeb().isAlertSupported();
    }
}

