/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import cz.etnetera.seb.SebContext;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public class SebContextWait
extends FluentWait<SebContext> {
    protected SebContext context;
    protected final Sleeper sleeper;
    protected Duration timeout;

    public SebContextWait(SebContext context, Clock clock, Sleeper sleeper, double timeout, double retryInterval) {
        super((Object)context, clock, sleeper);
        this.withTimeout((long)(timeout * 1000.0), TimeUnit.MILLISECONDS);
        this.pollingEvery((long)(retryInterval * 1000.0), TimeUnit.MILLISECONDS);
        this.ignoring(NotFoundException.class);
        this.context = context;
        this.sleeper = sleeper;
    }

    public SebContextWait(SebContext context, double timeout, double retryInterval) {
        this(context, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeout, retryInterval);
    }

    public SebContextWait(SebContext context, double timeout) {
        this(context, timeout, context.getWaitRetryInterval());
    }

    public SebContextWait(SebContext context) {
        this(context, context.getWaitTimeout());
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        TimeoutException ex = new TimeoutException(message, lastException);
        ex.addInfo("Driver info", this.context.getDriver().getClass().getName());
        if (this.context.getDriver() instanceof RemoteWebDriver) {
            RemoteWebDriver remote = (RemoteWebDriver)this.context.getDriver();
            if (remote.getSessionId() != null) {
                ex.addInfo("Session ID", remote.getSessionId().toString());
            }
            if (remote.getCapabilities() != null) {
                ex.addInfo("Capabilities", remote.getCapabilities().toString());
            }
        }
        throw ex;
    }

    public void untilTrue(final Predicate<SebContext> isTrue) {
        super.until((com.google.common.base.Predicate)new com.google.common.base.Predicate<SebContext>(){

            public boolean apply(SebContext input) {
                return isTrue.test(input);
            }
        });
    }

    public <V> V untilValid(final java.util.function.Function<SebContext, V> isTrue) {
        return (V)super.until(new Function<SebContext, V>(){

            public V apply(SebContext input) {
                return isTrue.apply(input);
            }
        });
    }

    public SebContextWait sleep() {
        try {
            this.sleeper.sleep(this.timeout);
            return this;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebDriverException((Throwable)e);
        }
    }

    public SebContextWait withTimeout(long duration, TimeUnit unit) {
        super.withTimeout(duration, unit);
        this.timeout = new Duration(duration, unit);
        return this;
    }

    public SebContextWait withMessage(String message) {
        return (SebContextWait)super.withMessage(message);
    }

    public SebContextWait withMessage(Supplier<String> messageSupplier) {
        return (SebContextWait)super.withMessage(messageSupplier);
    }

    public SebContextWait pollingEvery(long duration, TimeUnit unit) {
        return (SebContextWait)super.pollingEvery(duration, unit);
    }

    public <K extends Throwable> SebContextWait ignoreAll(Collection<Class<? extends K>> types) {
        return (SebContextWait)super.ignoreAll(types);
    }

    public SebContextWait ignoring(Class<? extends Throwable> exceptionType) {
        return (SebContextWait)super.ignoring(exceptionType);
    }

    public SebContextWait ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return (SebContextWait)super.ignoring(firstType, secondType);
    }
}

