/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.configuration;

import cz.etnetera.seb.configuration.SebConfiguration;
import cz.etnetera.seb.listener.SebListener;
import cz.etnetera.seb.listener.impl.PageSourceListener;
import cz.etnetera.seb.listener.impl.ScreenshotListener;
import cz.etnetera.seb.source.ChainedPropertiesSource;
import cz.etnetera.seb.source.DataSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BasicSebConfiguration
implements SebConfiguration,
ChainedPropertiesSource,
DataSource {
    public static final String SYSTEM_PROPERTIES_KEY = "system";
    public static final String DEFAULT_PROPERTIES_KEY = "default";
    public static final String DEFAULT_PROPERTIES_RESOURCE_NAME = "seb.properties";
    public static final String PREFIX = "seb.";
    public static final String BASE_URL = "seb.baseUrl";
    public static final String BASE_URL_REGEX = "seb.baseUrlRegex";
    public static final String URL_VERIFICATION = "seb.urlVerification";
    public static final String WAIT_TIMEOUT = "seb.waitTimeout";
    public static final String WAIT_RETRY_INTERVAL = "seb.waitRetryInterval";
    public static final String REPORTED = "seb.reported";
    public static final String REPORT_DIR = "seb.reportDir";
    protected List<ChainedPropertiesSource.PropertiesValue> propertiesHolder = new ArrayList<ChainedPropertiesSource.PropertiesValue>();
    protected Map<String, Object> dataHolder = new HashMap<String, Object>();

    public BasicSebConfiguration() {
        this.addSystemProperties().addDefaultProperties();
    }

    protected String getDefaultBaseUrl() {
        return null;
    }

    protected String getDefaultBaseUrlRegex() {
        String baseUrl = this.getBaseUrl();
        return baseUrl == null ? null : Pattern.quote(baseUrl);
    }

    protected boolean isDefaultUrlVerification() {
        return true;
    }

    protected WebDriver getDefaultDriver(DesiredCapabilities caps) {
        return new FirefoxDriver((Capabilities)caps);
    }

    protected DesiredCapabilities getDefaultCapabilities() {
        return null;
    }

    protected double getDefaultWaitTimeout() {
        return 5.0;
    }

    protected double getDefaultWaitRetryInterval() {
        return 0.1;
    }

    protected boolean isDefaultReported() {
        return false;
    }

    protected File getDefaultReportDir() {
        return new File("seb-report");
    }

    protected List<SebListener> getDefaultListeners() {
        return new ArrayList<SebListener>(Arrays.asList(new PageSourceListener(), new ScreenshotListener()));
    }

    @Override
    public void init() {
    }

    @Override
    public String getBaseUrl() {
        return this.getProperty(BASE_URL, this.getDefaultBaseUrl());
    }

    @Override
    public String getBaseUrlRegex() {
        return this.getProperty(BASE_URL_REGEX, this.getDefaultBaseUrl());
    }

    @Override
    public boolean isUrlVerification() {
        return this.getProperty(URL_VERIFICATION, Boolean.class, this.isDefaultUrlVerification());
    }

    @Override
    public WebDriver getDriver(DesiredCapabilities caps) {
        return this.getDefaultDriver(caps);
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        return this.getDefaultCapabilities();
    }

    @Override
    public double getWaitTimeout() {
        return this.getProperty(WAIT_TIMEOUT, Double.class, this.getDefaultWaitTimeout());
    }

    @Override
    public double getWaitRetryInterval() {
        return this.getProperty(WAIT_RETRY_INTERVAL, Double.class, this.getDefaultWaitRetryInterval());
    }

    @Override
    public boolean isReported() {
        return this.getProperty(REPORTED, Boolean.class, this.isDefaultReported());
    }

    @Override
    public File getReportDir() {
        String reportDir = this.getProperty(REPORT_DIR);
        return reportDir == null ? this.getDefaultReportDir() : new File(reportDir);
    }

    @Override
    public List<SebListener> getListeners() {
        return this.getDefaultListeners();
    }

    @Override
    public boolean isAlertSupported(WebDriver driver) {
        return true;
    }

    @Override
    public boolean isLazyDriver() {
        return true;
    }

    @Override
    public List<ChainedPropertiesSource.PropertiesValue> getPropertiesHolder() {
        return this.propertiesHolder;
    }

    @Override
    public Map<String, Object> getDataHolder() {
        return this.dataHolder;
    }

    public BasicSebConfiguration addDefaultProperties() {
        return (BasicSebConfiguration)this.addResourceProperties(DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicSebConfiguration addDefaultPropertiesBefore(String beforeKey) {
        return (BasicSebConfiguration)this.addResourcePropertiesBefore(beforeKey, DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicSebConfiguration addDefaultPropertiesAfter(String afterKey) {
        return (BasicSebConfiguration)this.addResourcePropertiesAfter(afterKey, DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicSebConfiguration addSystemProperties() {
        return (BasicSebConfiguration)this.addProperties(SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicSebConfiguration addSystemPropertiesBefore(String beforeKey) {
        return (BasicSebConfiguration)this.addPropertiesBefore(beforeKey, SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicSebConfiguration addSystemPropertiesAfter(String afterKey) {
        return (BasicSebConfiguration)this.addPropertiesAfter(afterKey, SYSTEM_PROPERTIES_KEY, System.getProperties());
    }

    public BasicSebConfiguration pushDefaultProperties() {
        return (BasicSebConfiguration)this.pushResourceProperties(DEFAULT_PROPERTIES_KEY, DEFAULT_PROPERTIES_RESOURCE_NAME);
    }

    public BasicSebConfiguration pushSystemProperties() {
        return (BasicSebConfiguration)this.pushProperties(SYSTEM_PROPERTIES_KEY, System.getProperties());
    }
}

