/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.element;

import cz.etnetera.seb.SebContext;
import cz.etnetera.seb.element.FindByDefault;
import cz.etnetera.seb.element.RequiredElement;
import cz.etnetera.seb.element.SebElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class SebFieldDecorator
implements FieldDecorator {
    protected static final String TYPE_NAME_PREFIX = "class ";
    protected SebContext context;

    public SebFieldDecorator(SebContext context) {
        this.context = context;
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!this.isSupported(field)) {
            return null;
        }
        Class<Object> elementCls = null;
        boolean isList = false;
        if (WebElement.class.isAssignableFrom(field.getType())) {
            elementCls = field.getType();
        } else if (List.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                return null;
            }
            Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            elementCls = this.getClassFromType(listType);
            if (!WebElement.class.isAssignableFrom(elementCls)) {
                return null;
            }
            isList = true;
        } else {
            return null;
        }
        if (!SebElement.class.isAssignableFrom(elementCls)) {
            elementCls = SebElement.class;
        }
        if (!isList) {
            return this.context.getSeb().getElementLoader().findOne(this.context, loader, field, elementCls, !field.isAnnotationPresent(RequiredElement.class));
        }
        return this.context.getSeb().getElementLoader().find(this.context, loader, field, elementCls);
    }

    protected boolean isSupported(Field field) {
        return field.isAnnotationPresent(FindByDefault.class) || field.isAnnotationPresent(FindBy.class) || field.isAnnotationPresent(FindBys.class) || field.isAnnotationPresent(FindAll.class);
    }

    protected Class<?> getClassFromType(Type type) {
        if (type == null) {
            return null;
        }
        String className = type.getTypeName();
        if (className.startsWith(TYPE_NAME_PREFIX)) {
            className = className.substring(TYPE_NAME_PREFIX.length());
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

