/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.event;

import cz.etnetera.seb.Seb;
import cz.etnetera.seb.SebContext;
import cz.etnetera.seb.listener.SebListener;
import java.io.File;
import java.time.LocalDateTime;
import org.openqa.selenium.WebDriver;

public abstract class SebEvent {
    protected SebContext context;
    protected LocalDateTime time;
    protected String sebLabel;
    protected String label;
    protected String filePrefix;

    public SebEvent with(SebContext context, LocalDateTime time) {
        this.context = context;
        this.time = time;
        return this;
    }

    public abstract void notify(SebListener var1);

    public void notifyEnabled(SebListener listener) {
        if (listener.isEnabled(this)) {
            this.notify(listener);
        }
    }

    public void init() {
        this.sebLabel = this.context.getSeb().getLabel();
        this.label = this.generateLabel();
        this.filePrefix = this.context.getUtils().join("-", this.time.format(Seb.FILE_DATE_FORMATTER), this.sebLabel, this.context.getClass().getSimpleName(), this.label);
    }

    public SebContext getContext() {
        return this.context;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public Seb getSeb() {
        return this.context.getSeb();
    }

    public <T> T getSeb(Class<T> seb) {
        return this.context.getSeb(seb);
    }

    public WebDriver getDriver() {
        return this.context.getDriver();
    }

    public <T> T getDriver(Class<T> driver) {
        return this.context.getDriver(driver);
    }

    public void saveFile(String content, String name, String extension) {
        this.context.saveFile(content, this.getEventFileName(name), extension);
    }

    public void saveFile(byte[] bytes, String name, String extension) {
        this.context.saveFile(bytes, this.getEventFileName(name), extension);
    }

    public void saveFile(File file, String name, String extension) {
        this.context.saveFile(file, this.getEventFileName(name), extension);
    }

    protected String getEventFileName(String name) {
        return this.context.getUtils().join("-", this.filePrefix, name);
    }

    protected String generateLabel() {
        String endTrim;
        String name = this.getClass().getSimpleName();
        return name.endsWith(endTrim = "Event") ? name.substring(0, name.length() - endTrim.length()) : name;
    }
}

