/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.listener;

import cz.etnetera.seb.Seb;
import cz.etnetera.seb.event.SebEvent;
import cz.etnetera.seb.event.impl.AfterChangeValueOfEvent;
import cz.etnetera.seb.event.impl.AfterClickOnEvent;
import cz.etnetera.seb.event.impl.AfterFindByEvent;
import cz.etnetera.seb.event.impl.AfterModuleInitEvent;
import cz.etnetera.seb.event.impl.AfterNavigateBackEvent;
import cz.etnetera.seb.event.impl.AfterNavigateForwardEvent;
import cz.etnetera.seb.event.impl.AfterNavigateToEvent;
import cz.etnetera.seb.event.impl.AfterPageInitEvent;
import cz.etnetera.seb.event.impl.AfterScriptEvent;
import cz.etnetera.seb.event.impl.AfterSebQuitEvent;
import cz.etnetera.seb.event.impl.BeforeChangeValueOfEvent;
import cz.etnetera.seb.event.impl.BeforeClickOnEvent;
import cz.etnetera.seb.event.impl.BeforeDriverConstructEvent;
import cz.etnetera.seb.event.impl.BeforeFindByEvent;
import cz.etnetera.seb.event.impl.BeforeModuleInitEvent;
import cz.etnetera.seb.event.impl.BeforeNavigateBackEvent;
import cz.etnetera.seb.event.impl.BeforeNavigateForwardEvent;
import cz.etnetera.seb.event.impl.BeforeNavigateToEvent;
import cz.etnetera.seb.event.impl.BeforePageInitEvent;
import cz.etnetera.seb.event.impl.BeforeScriptEvent;
import cz.etnetera.seb.event.impl.BeforeSebQuitEvent;
import cz.etnetera.seb.event.impl.OnExceptionEvent;
import cz.etnetera.seb.event.impl.OnFileSaveEvent;
import cz.etnetera.seb.event.impl.OnModuleInitExceptionEvent;
import cz.etnetera.seb.event.impl.OnPageInitExceptionEvent;
import cz.etnetera.seb.event.impl.OnReportEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class SebListener {
    protected Seb seb;
    protected String label;
    protected Set<Class<? extends SebEvent>> enabledEvents;
    protected Set<Class<? extends SebEvent>> disabledEvents;

    public void init(Seb seb) {
        this.seb = seb;
        this.label = this.generateLabel();
    }

    public boolean isEnabled(SebEvent event) {
        return this.isEnabled(event.getClass());
    }

    public boolean isEnabled(Class<? extends SebEvent> event) {
        if (this.enabledEvents != null) {
            return this.enabledEvents.contains(event);
        }
        if (this.disabledEvents != null) {
            return !this.disabledEvents.contains(event);
        }
        return true;
    }

    public SebListener enable(Class<? extends SebEvent> ... events) {
        if (events != null) {
            this.disabledEvents = null;
            if (this.enabledEvents == null) {
                this.enabledEvents = new HashSet<Class<? extends SebEvent>>();
            }
            for (Class<? extends SebEvent> event : events) {
                this.enabledEvents.add(event);
            }
        }
        return this;
    }

    public SebListener disable(Class<? extends SebEvent> ... events) {
        if (events != null) {
            this.enabledEvents = null;
            if (this.disabledEvents == null) {
                this.disabledEvents = new HashSet<Class<? extends SebEvent>>();
            }
            for (Class<? extends SebEvent> event : events) {
                this.disabledEvents.add(event);
            }
        }
        return this;
    }

    public void onReport(OnReportEvent event) {
    }

    public void onFileSave(OnFileSaveEvent event) {
    }

    public void beforeDriverConstruct(BeforeDriverConstructEvent event) {
    }

    public void beforePageInit(BeforePageInitEvent event) {
    }

    public void onPageInitException(OnPageInitExceptionEvent event) {
    }

    public void afterPageInit(AfterPageInitEvent event) {
    }

    public void beforeModuleInit(BeforeModuleInitEvent event) {
    }

    public void onModuleInitException(OnModuleInitExceptionEvent event) {
    }

    public void afterModuleInit(AfterModuleInitEvent event) {
    }

    public void beforeSebQuit(BeforeSebQuitEvent event) {
    }

    public void afterSebQuit(AfterSebQuitEvent event) {
    }

    public void beforeNavigateTo(BeforeNavigateToEvent event) {
    }

    public void afterNavigateTo(AfterNavigateToEvent event) {
    }

    public void beforeNavigateBack(BeforeNavigateBackEvent event) {
    }

    public void afterNavigateBack(AfterNavigateBackEvent event) {
    }

    public void beforeNavigateForward(BeforeNavigateForwardEvent event) {
    }

    public void afterNavigateForward(AfterNavigateForwardEvent event) {
    }

    public void beforeFindBy(BeforeFindByEvent event) {
    }

    public void afterFindBy(AfterFindByEvent event) {
    }

    public void beforeClickOn(BeforeClickOnEvent event) {
    }

    public void afterClickOn(AfterClickOnEvent event) {
    }

    public void beforeChangeValueOf(BeforeChangeValueOfEvent event) {
    }

    public void afterChangeValueOf(AfterChangeValueOfEvent event) {
    }

    public void beforeScript(BeforeScriptEvent event) {
    }

    public void afterScript(AfterScriptEvent event) {
    }

    public void onException(OnExceptionEvent event) {
    }

    protected void saveFile(SebEvent event, String content, String name, String extension) {
        event.saveFile(content, this.getListenerFileName(name), extension);
    }

    protected void saveFile(SebEvent event, byte[] bytes, String name, String extension) {
        event.saveFile(bytes, this.getListenerFileName(name), extension);
    }

    protected void saveFile(SebEvent event, File file, String name, String extension) {
        event.saveFile(file, this.getListenerFileName(name), extension);
    }

    protected String getListenerFileName(String name) {
        return this.seb.getUtils().join("-", this.label, name);
    }

    protected String generateLabel() {
        String endTrim;
        String name = this.getClass().getSimpleName();
        return name.endsWith(endTrim = "Listener") ? name.substring(0, name.length() - endTrim.length()) : name;
    }
}

