/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.source;

import cz.etnetera.seb.SebException;
import cz.etnetera.seb.source.PropertiesSource;
import cz.etnetera.seb.source.PropertySource;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public interface ChainedPropertiesSource
extends PropertySource {
    public List<PropertiesValue> getPropertiesHolder();

    default public List<Properties> getProperties() {
        return this.getPropertiesHolder().stream().map(v -> v.getProperties()).collect(Collectors.toList());
    }

    default public Map<String, Properties> getPropertiesWithKeys() {
        return this.getPropertiesHolder().stream().collect(Collectors.toMap(PropertiesValue::getKey, PropertiesValue::getProperties));
    }

    default public Properties getMergedProperties() {
        Properties props = new Properties();
        this.getPropertiesHolder().stream().sorted(Collections.reverseOrder()).forEach(v -> props.putAll((Map<?, ?>)v.getProperties()));
        return props;
    }

    default public Properties getProperties(String key) {
        return this.getPropertiesHolder().stream().filter(v -> v.equals(key)).map(v -> v.getProperties()).findFirst().orElse(null);
    }

    default public boolean removeProperties(String key) {
        return this.getPropertiesHolder().remove(new PropertiesValue(key, null));
    }

    default public ChainedPropertiesSource addProperties(String key, Properties properties) {
        if (properties != null) {
            this.removeProperties(key);
            this.getPropertiesHolder().add(new PropertiesValue(key, PropertiesSource.loadProperties(properties)));
        }
        return this;
    }

    default public ChainedPropertiesSource addPropertiesBefore(String beforeKey, String key, Properties properties) {
        if (properties != null) {
            int i = this.getPropertiesHolder().indexOf(new PropertiesValue(beforeKey, null));
            if (i < 0) {
                throw new SebException("There are no properties with key " + beforeKey);
            }
            this.removeProperties(key);
            this.getPropertiesHolder().add(i, new PropertiesValue(key, PropertiesSource.loadProperties(properties)));
        }
        return this;
    }

    default public ChainedPropertiesSource addPropertiesAfter(String afterKey, String key, Properties properties) {
        if (properties != null) {
            int i = this.getPropertiesHolder().indexOf(new PropertiesValue(afterKey, null));
            if (i < 0) {
                throw new SebException("There are no properties with key " + afterKey);
            }
            this.removeProperties(key);
            this.getPropertiesHolder().add(i + 1, new PropertiesValue(key, PropertiesSource.loadProperties(properties)));
        }
        return this;
    }

    default public ChainedPropertiesSource addFileProperties(String key, File file) {
        return this.addProperties(key, PropertiesSource.loadProperties(file));
    }

    default public ChainedPropertiesSource addFilePropertiesBefore(String beforeKey, String key, File file) {
        return this.addPropertiesBefore(beforeKey, key, PropertiesSource.loadProperties(file));
    }

    default public ChainedPropertiesSource addFilePropertiesAfter(String afterKey, String key, File file) {
        return this.addPropertiesAfter(afterKey, key, PropertiesSource.loadProperties(file));
    }

    default public ChainedPropertiesSource addResourceProperties(String key, String resourceName) {
        return this.addProperties(key, PropertiesSource.loadProperties(resourceName));
    }

    default public ChainedPropertiesSource addResourcePropertiesBefore(String beforeKey, String key, String resourceName) {
        return this.addPropertiesBefore(beforeKey, key, PropertiesSource.loadProperties(resourceName));
    }

    default public ChainedPropertiesSource addResourcePropertiesAfter(String afterKey, String key, String resourceName) {
        return this.addPropertiesAfter(afterKey, key, PropertiesSource.loadProperties(resourceName));
    }

    default public ChainedPropertiesSource pushProperties(String key, Properties properties) {
        if (properties != null) {
            this.getPropertiesHolder().add(0, new PropertiesValue(key, PropertiesSource.loadProperties(properties)));
        }
        return this;
    }

    default public ChainedPropertiesSource pushFileProperties(String key, File file) {
        return this.pushProperties(key, PropertiesSource.loadProperties(file));
    }

    default public ChainedPropertiesSource pushResourceProperties(String key, String resourceName) {
        return this.pushProperties(key, PropertiesSource.loadProperties(resourceName));
    }

    @Override
    default public String getProperty(String key) {
        if (this.getPropertiesHolder() != null) {
            for (PropertiesValue v : this.getPropertiesHolder()) {
                String value = v.getProperties().getProperty(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static class PropertiesValue {
        protected String key;
        protected Properties properties;

        public PropertiesValue(String key, Properties properties) {
            this.key = key;
            this.properties = properties;
        }

        public String getKey() {
            return this.key;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropertiesValue) {
                return this.key.equals(((PropertiesValue)obj).getKey());
            }
            return false;
        }
    }
}

