/*
 * Decompiled with CFR 0.152.
 */
package cz.etnetera.seb.source;

import cz.etnetera.seb.SebException;
import cz.etnetera.seb.source.PropertySource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public interface PropertiesSource
extends PropertySource {
    public static final String ENCODING = "UTF-8";

    public static Properties loadProperties(Object source) {
        if (source instanceof Properties) {
            return PropertiesSource.loadProperties((Properties)source);
        }
        if (source instanceof File) {
            return PropertiesSource.loadProperties((File)source);
        }
        if (source instanceof String) {
            return PropertiesSource.loadProperties((String)source);
        }
        throw new SebException("Unsupported properties source type " + source.getClass());
    }

    public static Properties loadProperties(Properties properties) {
        return properties;
    }

    public static Properties loadProperties(File file) {
        if (!file.canRead()) {
            throw new SebException("Properties file is not readable " + file);
        }
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
        }
        catch (IOException e) {
            throw new SebException("Error while reading properties file " + file);
        }
        return properties;
    }

    public static Properties loadProperties(String resourceName) {
        InputStream is = PropertiesSource.class.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new SebException("Properties resource does not exists " + resourceName);
        }
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(is, ENCODING));
        }
        catch (IOException e) {
            throw new SebException("Error while reading properties resource " + resourceName);
        }
        return properties;
    }

    public Properties getProperties();

    @Override
    default public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }
}

