/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.spayd;

import cz.geek.spayd.BankAccount;
import org.apache.commons.lang.Validate;

public class CzechBankAccount
extends BankAccount {
    public CzechBankAccount(String accountPrefix, String accountNumber, String bankCode) {
        super(CzechBankAccount.createIban(accountPrefix, accountNumber, bankCode));
    }

    public CzechBankAccount(String number, String bankCode) {
        this(null, number, bankCode);
    }

    public CzechBankAccount(String account) {
        super(CzechBankAccount.parseIban(account));
    }

    private static String parseIban(String account) {
        String accountNumber;
        String accountPrefix;
        Validate.notEmpty((String)account);
        String[] split = account.split("/");
        if (split.length != 2) {
            throw new IllegalArgumentException("Expecting string in pattern 'number/bank': " + account);
        }
        String bankCode = split[1].trim();
        String[] number = split[0].split("-");
        if (number.length > 2) {
            throw new IllegalArgumentException("Only one '-' allowed in bank number: " + account);
        }
        if (number.length == 2) {
            accountPrefix = number[0].trim();
            accountNumber = number[1].trim();
        } else {
            accountPrefix = null;
            accountNumber = number[0].trim();
        }
        return CzechBankAccount.createIban(accountPrefix, accountNumber, bankCode);
    }

    private static String createIban(String accountPrefix, String accountNumber, String bankCode) {
        String prefix = String.format("%06d", CzechBankAccount.longValue11("accountPrefix", accountPrefix != null ? accountPrefix : "000000"));
        String number = String.format("%010d", CzechBankAccount.longValue11("accountNumber", accountNumber));
        String bank = String.format("%04d", CzechBankAccount.longValue("bankCode", bankCode));
        String buf = bank + prefix + number + "123500";
        int index = 0;
        int pz = -1;
        while (index <= buf.length()) {
            String dividend;
            if (pz < 0) {
                dividend = buf.substring(index, Math.min(index + 9, buf.length()));
                index += 9;
            } else if (pz >= 0 && pz <= 9) {
                dividend = pz + buf.substring(index, Math.min(index + 8, buf.length()));
                index += 8;
            } else {
                dividend = pz + buf.substring(index, Math.min(index + 7, buf.length()));
                index += 7;
            }
            pz = Integer.valueOf(dividend) % 97;
        }
        pz = 98 - pz;
        return "CZ" + String.format("%02d", pz) + bank + prefix + number;
    }

    private static long longValue11(String name, String number) {
        long value = CzechBankAccount.longValue(name, number);
        int weight = 1;
        int sum = 0;
        for (int k = number.length() - 1; k >= 0; --k) {
            sum += (number.charAt(k) - 48) * weight;
            weight *= 2;
        }
        Validate.isTrue((sum % 11 == 0 ? 1 : 0) != 0, (String)(name + " must pass bank mod 11 test"));
        return value;
    }

    private static long longValue(String name, String value) {
        Validate.notEmpty((String)value, (String)(name + " can't be empty"));
        return Long.valueOf(value);
    }
}

