/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.spayd;

import cz.geek.spayd.SpaydValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.Validate;

public class SimpleValue<T>
implements SpaydValue {
    private T value;

    private SimpleValue(T value) {
        Validate.notNull(value);
        this.value = value;
    }

    @Override
    public String asString() {
        return SimpleValue.escapeDisallowedCharacters(this.value.toString().trim());
    }

    private static String escapeDisallowedCharacters(String originalString) {
        try {
            StringBuilder working = new StringBuilder();
            for (int i = 0; i < originalString.length(); ++i) {
                if (originalString.charAt(i) > '\u007f') {
                    working.append(URLEncoder.encode("" + originalString.charAt(i), "UTF-8"));
                    continue;
                }
                if (originalString.charAt(i) == '*') {
                    working.append("%2A");
                    continue;
                }
                if (originalString.charAt(i) == '+') {
                    working.append("%2B");
                    continue;
                }
                if (originalString.charAt(i) == '%') {
                    working.append("%25");
                    continue;
                }
                working.append(originalString.charAt(i));
            }
            return working.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 should ever be supported", e);
        }
    }

    public static <T> SimpleValue<T> simpleValue(T value) {
        return new SimpleValue<T>(value);
    }
}

