/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.spayd;

import cz.geek.spayd.AlternateAccounts;
import cz.geek.spayd.BankAccount;
import cz.geek.spayd.SimpleValue;
import cz.geek.spayd.SpaydDate;
import cz.geek.spayd.SpaydValue;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class SpaydPayment {
    public static final String MIME_TYPE = "application/x-shortpaymentdescriptor";
    protected final Map<String, SpaydValue> elements = new LinkedHashMap<String, SpaydValue>();

    public SpaydPayment(BankAccount bankAccount) {
        Validate.notNull((Object)bankAccount);
        this.elements.put("ACC", bankAccount);
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SPD*1.0");
        for (Map.Entry<String, SpaydValue> entry : this.elements.entrySet()) {
            builder.append("*").append(entry.getKey()).append(":").append(entry.getValue().asString());
        }
        return builder.toString();
    }

    public void setAlternateAccounts(AlternateAccounts alternateAccounts) {
        Validate.notNull((Object)alternateAccounts);
        this.elements.put("ALT-ACC", alternateAccounts);
    }

    protected void putSimpleValue(String key, Object value) {
        this.elements.put(key, SimpleValue.simpleValue(value));
    }

    public void setAlternateAccounts(BankAccount ... bankAccount) {
        this.setAlternateAccounts(new AlternateAccounts(bankAccount));
    }

    public void setAmount(BigDecimal amount) {
        this.putSimpleValue("AM", amount);
    }

    public void setAmount(int amount) {
        this.setAmount(new BigDecimal(amount));
    }

    public void setCurrency(String currency) {
        this.putSimpleValue("CC", currency);
    }

    public void setSendersReference(int sendersReference) {
        this.putSimpleValue("RF", sendersReference);
    }

    public void setRecipientName(String recipientName) {
        this.putSimpleValue("RN", recipientName);
    }

    public void setDate(Date date) {
        this.elements.put("DT", new SpaydDate(date));
    }

    public void setPaymentType(String paymentType) {
        this.putSimpleValue("PT", paymentType);
    }

    public void setMessage(String message) {
        this.putSimpleValue("MSG", message);
    }

    public void setEmailNotify(String email) {
        this.putSimpleValue("NT", "E");
        this.putSimpleValue("NTA", email);
    }

    public void setPhoneNotify(String phone) {
        this.putSimpleValue("NT", "P");
        this.putSimpleValue("NTA", phone);
    }
}

