/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.spayd;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import cz.geek.spayd.SpaydPayment;
import cz.geek.spayd.SpaydQRException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang.Validate;

public class SpaydQRFactory {
    public static final int MIN_QR_SIZE = 200;
    public static final int DEFAULT_QR_SIZE = 250;
    public static final int MAX_QR_SIZE = 800;
    private final String brandFont = "Verdana";
    private int size = 250;
    private boolean branded = true;
    private String brandText = "QR Platba";

    public void saveQRCode(SpaydPayment spaydPayment, String formatName, OutputStream stream) {
        try {
            ImageIO.write((RenderedImage)this.createQRCode(spaydPayment), formatName, stream);
        }
        catch (IOException e) {
            throw new SpaydQRException("Unable to create QR code", e);
        }
    }

    public void saveQRCode(SpaydPayment spaydPayment, String formatName, File file) {
        try {
            ImageIO.write((RenderedImage)this.createQRCode(spaydPayment), formatName, file);
        }
        catch (IOException e) {
            throw new SpaydQRException("Unable to create QR code", e);
        }
    }

    public BufferedImage createQRCode(SpaydPayment spaydPayment) {
        Validate.notNull((Object)spaydPayment);
        return this.createQRCode(spaydPayment.asString());
    }

    public BufferedImage createQRCode(String paymentString) {
        BitMatrix matrix;
        int barsize;
        Validate.notEmpty((String)paymentString);
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "ISO-8859-1");
            QRCode code = Encoder.encode((String)paymentString, (ErrorCorrectionLevel)ErrorCorrectionLevel.M, hints);
            hints.put(EncodeHintType.ERROR_CORRECTION, (String)ErrorCorrectionLevel.M);
            barsize = this.size / (code.getMatrix().getWidth() + 8);
            matrix = writer.encode(paymentString, BarcodeFormat.QR_CODE, this.size, this.size, hints);
        }
        catch (WriterException e) {
            throw new SpaydQRException("Unable to create QR code", e);
        }
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        return this.isBranded() ? this.brandImage(image, barsize) : image;
    }

    protected BufferedImage brandImage(BufferedImage image, int barsize) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        Font font = new Font("Verdana", 1, this.size / 12);
        BasicStroke bs = new BasicStroke(2.0f);
        g.setStroke(bs);
        g.setColor(Color.BLACK);
        g.drawLine(0, 0, this.size, 0);
        g.drawLine(0, 0, 0, this.size);
        g.drawLine(this.size, 0, this.size, this.size);
        g.drawLine(0, this.size, this.size, this.size);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(this.brandText, g);
        g.setColor(Color.WHITE);
        g.fillRect(2 * barsize, this.size - fm.getAscent(), (int)rect.getWidth() + 4 * barsize, (int)rect.getHeight());
        int padding = 4 * barsize;
        BufferedImage paddedImage = new BufferedImage(this.size + 2 * padding, this.size + padding + (int)rect.getHeight(), image.getType());
        Graphics2D g2 = paddedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g2.setFont(font);
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, paddedImage.getWidth(), paddedImage.getHeight());
        g2.drawImage(image, padding, padding, Color.WHITE, null);
        g2.setColor(Color.BLACK);
        g2.drawString(this.brandText, padding + 4 * barsize, (int)((double)(padding + this.size) + rect.getHeight() - (double)barsize));
        return paddedImage;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size > 800) {
            throw new IllegalArgumentException("Max size is 800");
        }
        if (size < 200) {
            throw new IllegalArgumentException("Min size is 200");
        }
        this.size = size;
    }

    public boolean isBranded() {
        return this.branded;
    }

    public void setBranded(boolean branded) {
        this.branded = branded;
    }

    public String getBrandText() {
        return this.brandText;
    }

    public void setBrandText(String brandText) {
        Validate.notEmpty((String)brandText);
        this.brandText = brandText;
    }

    public String getBrandFont() {
        Validate.notEmpty((String)"Verdana");
        return "Verdana";
    }
}

