/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.generator;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.internal.shaded.com.google.common.base.Joiner;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.repository.ConfigRepository;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.util.CamelCase;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelGenerator {
    private final String javaPackage;
    private final String className;
    private final File sourceConfigPath;
    private final File outputPath;

    public ModelGenerator(String javaPackage, String className, String sourceConfigPath, String outputPath) {
        Preconditions.checkArgument(StringUtils.isNotBlank(javaPackage), "Java package name is missing");
        Preconditions.checkArgument(StringUtils.isNotBlank(className), "Class name is missing");
        this.javaPackage = javaPackage;
        this.className = className;
        this.sourceConfigPath = new File(sourceConfigPath);
        this.outputPath = new File(outputPath);
        if (!this.sourceConfigPath.exists()) {
            throw new IllegalArgumentException("Source config not found at [ " + sourceConfigPath + " ]");
        }
        if (!this.outputPath.isAbsolute()) {
            throw new IllegalArgumentException("Output path must be absolute [ " + outputPath + " ]");
        }
    }

    public void generate() throws Exception {
        Configuration conf = this.getConf();
        File output = this.getOutputDirForPackage(this.outputPath, this.javaPackage);
        if (!output.exists() && !output.mkdirs()) {
            throw new RuntimeException("Failed to create directories for [ " + output.getAbsolutePath() + " ]");
        }
        ConfigRepository repo = ConfigRepository.Builder.of((Config)ConfigFactory.parseFile(this.sourceConfigPath).resolve()).withReadOnly(true).withValidate(false).withLoadFamilies(false).withLoadAccessors(false).build();
        HashMap<String, Object> root = new HashMap<String, Object>();
        List<Map<String, Object>> entities = this.getEntities((Repository)repo);
        File outputFile = new File(output, this.className + ".java");
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            root.put("input_path", this.sourceConfigPath.getAbsoluteFile());
            root.put("input_config", this.readFileToString(this.sourceConfigPath));
            root.put("java_package", this.javaPackage);
            root.put("java_classname", this.className);
            root.put("java_config_resourcename", this.sourceConfigPath.getName());
            root.put("entities", entities);
            Template template = conf.getTemplate("java-source.ftlh");
            template.process(root, new OutputStreamWriter(out));
        }
    }

    private Configuration getConf() {
        Configuration conf = new Configuration(Configuration.VERSION_2_3_23);
        conf.setDefaultEncoding("utf-8");
        conf.setClassForTemplateLoading(this.getClass(), "/");
        conf.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        conf.setLogTemplateExceptions(false);
        return conf;
    }

    private File getOutputDirForPackage(File outputPath, String javaPackage) {
        String packagePath = javaPackage.replaceAll("\\.", File.separator);
        return new File(outputPath, packagePath);
    }

    private List<Map<String, Object>> getEntities(Repository repo) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        repo.getAllEntities().forEach(e -> ret.add(this.getEntityDict((EntityDescriptor)e)));
        return ret;
    }

    private Map<String, Object> getEntityDict(EntityDescriptor e) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("classname", this.toClassName(e.getName()));
        ret.put("name", e.getName());
        ret.put("nameCamel", CamelCase.apply((String)e.getName()));
        List attributes = e.getAllAttributes().stream().map(attr -> {
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            String nameModified = attr.toAttributePrefix(false);
            attrMap.put("wildcard", attr.isWildcard());
            attrMap.put("nameRaw", attr.getName());
            attrMap.put("name", nameModified);
            attrMap.put("nameCamel", CamelCase.apply((String)nameModified));
            attrMap.put("nameUpper", nameModified.toUpperCase());
            attrMap.put("type", attr.getSchemeUri().getSchemeSpecificPart());
            return attrMap;
        }).collect(Collectors.toList());
        ret.put("attributes", attributes);
        return ret;
    }

    private String toClassName(String name) {
        return CamelCase.apply((String)name);
    }

    private String readFileToString(File path) throws IOException {
        return Joiner.on("\n + ").join(IOUtils.readLines((InputStream)new FileInputStream(path), "UTF-8").stream().map(s -> "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"") + "\\n\"").collect(Collectors.toList()));
    }
}

