/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.maven;

import cz.o2.proxima.generator.ModelGenerator;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile")
public class CompileMojo
extends AbstractMojo {
    @Parameter
    private String outputDir;
    @Parameter
    private String config;
    @Parameter
    private String javaPackage;
    @Parameter
    private String className = "Model";
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        File targetOutputDir = new File(this.outputDir);
        if (!targetOutputDir.isAbsolute()) {
            targetOutputDir = new File(new File(this.project.getBasedir(), "target"), this.outputDir);
        }
        ModelGenerator generator = new ModelGenerator(this.javaPackage, this.className, this.config, targetOutputDir.getAbsolutePath());
        try {
            generator.generate();
            this.project.addCompileSourceRoot(targetOutputDir.getCanonicalPath());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Cannot create output", ex);
        }
    }

    private void validate() throws MojoFailureException {
        if (this.outputDir == null || this.config == null || this.javaPackage == null) {
            throw new MojoFailureException("Missing required parameter `outputDir', `config' or `javaPackage'");
        }
    }
}

