/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.dataset.windowing;

import cz.seznam.euphoria.core.annotation.stability.Experimental;
import cz.seznam.euphoria.core.client.dataset.windowing.MergingWindowing;
import cz.seznam.euphoria.core.client.dataset.windowing.TimeInterval;
import cz.seznam.euphoria.core.client.dataset.windowing.WindowedElement;
import cz.seznam.euphoria.core.client.triggers.AfterFirstCompositeTrigger;
import cz.seznam.euphoria.core.client.triggers.PeriodicTimeTrigger;
import cz.seznam.euphoria.core.client.triggers.TimeTrigger;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.core.client.util.Pair;
import cz.seznam.euphoria.shadow.com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Session<T>
implements MergingWindowing<T, TimeInterval> {
    private final long gapDurationMillis;
    @Nullable
    private Duration earlyTriggeringPeriod;

    public static <T> Session<T> of(Duration gapDuration) {
        return new Session<T>(gapDuration.toMillis());
    }

    private Session(long gapDurationMillis) {
        Preconditions.checkArgument(gapDurationMillis > 0L, "Windowing with zero duration");
        this.gapDurationMillis = gapDurationMillis;
    }

    @Experimental(value="https://github.com/seznam/euphoria/issues/43")
    public <T> Session<T> earlyTriggering(Duration timeout) {
        this.earlyTriggeringPeriod = Objects.requireNonNull(timeout);
        return this;
    }

    @Override
    public Iterable<TimeInterval> assignWindowsToElement(WindowedElement<?, T> el) {
        long stamp = el.getTimestamp();
        TimeInterval ret = new TimeInterval(stamp, stamp + this.gapDurationMillis);
        return Collections.singleton(ret);
    }

    @Override
    public Trigger<TimeInterval> getTrigger() {
        if (this.earlyTriggeringPeriod != null) {
            return new AfterFirstCompositeTrigger<TimeInterval>(Arrays.asList(new TimeTrigger(), new PeriodicTimeTrigger(this.earlyTriggeringPeriod.toMillis())));
        }
        return new TimeTrigger();
    }

    @Override
    public Collection<Pair<Collection<TimeInterval>, TimeInterval>> mergeWindows(Collection<TimeInterval> actives) {
        if (actives.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<TimeInterval> sorted = new ArrayList<TimeInterval>(actives);
        Collections.sort(sorted);
        Iterator windows = sorted.iterator();
        ArrayList<Pair<Object, TimeInterval>> merges = null;
        ArrayList<TimeInterval> toMerge = null;
        TimeInterval mergeCandidate = (TimeInterval)windows.next();
        boolean transientCandidate = false;
        while (windows.hasNext()) {
            TimeInterval w = (TimeInterval)windows.next();
            if (mergeCandidate.intersects(w)) {
                if (toMerge == null) {
                    toMerge = new ArrayList<TimeInterval>();
                }
                if (!transientCandidate) {
                    toMerge.add(mergeCandidate);
                }
                toMerge.add(w);
                mergeCandidate = mergeCandidate.cover(w);
                transientCandidate = true;
                continue;
            }
            if (toMerge != null && !toMerge.isEmpty()) {
                if (merges == null) {
                    merges = new ArrayList();
                }
                merges.add(Pair.of(toMerge, mergeCandidate));
                toMerge = null;
            }
            mergeCandidate = w;
            transientCandidate = false;
        }
        if (toMerge != null) {
            if (merges == null) {
                merges = new ArrayList<Pair<Object, TimeInterval>>();
            }
            merges.add(Pair.of(toMerge, mergeCandidate));
        }
        return merges == null ? Collections.emptyList() : merges;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Session) {
            Session other = (Session)obj;
            return other.earlyTriggeringPeriod == this.earlyTriggeringPeriod && other.gapDurationMillis == this.gapDurationMillis;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.earlyTriggeringPeriod, this.gapDurationMillis);
    }
}

