/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.dataset.windowing;

import cz.seznam.euphoria.core.client.dataset.windowing.TimeInterval;
import cz.seznam.euphoria.core.client.dataset.windowing.WindowedElement;
import cz.seznam.euphoria.core.client.dataset.windowing.Windowing;
import cz.seznam.euphoria.core.client.triggers.AfterFirstCompositeTrigger;
import cz.seznam.euphoria.core.client.triggers.PeriodicTimeTrigger;
import cz.seznam.euphoria.core.client.triggers.TimeTrigger;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.shadow.com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;

public class Time<T>
implements Windowing<T, TimeInterval> {
    private final long durationMillis;
    @Nullable
    private Duration earlyTriggeringPeriod;

    public static <T> Time<T> of(Duration duration) {
        return new Time<T>(duration.toMillis());
    }

    private Time(long durationMillis) {
        Preconditions.checkArgument(durationMillis > 0L, "Windowing with zero duration");
        this.durationMillis = durationMillis;
    }

    public <T> Time<T> earlyTriggering(Duration timeout) {
        this.earlyTriggeringPeriod = Objects.requireNonNull(timeout);
        return this;
    }

    @Override
    public Iterable<TimeInterval> assignWindowsToElement(WindowedElement<?, T> el) {
        long stamp = el.getTimestamp();
        long start = stamp - (stamp + this.durationMillis) % this.durationMillis;
        long end = start + this.durationMillis;
        return Collections.singleton(new TimeInterval(start, end));
    }

    @Override
    public Trigger<TimeInterval> getTrigger() {
        if (this.earlyTriggeringPeriod != null) {
            return new AfterFirstCompositeTrigger<TimeInterval>(Arrays.asList(new TimeTrigger(), new PeriodicTimeTrigger(this.earlyTriggeringPeriod.toMillis())));
        }
        return new TimeTrigger();
    }

    @Nullable
    public Duration getEarlyTriggeringPeriod() {
        return this.earlyTriggeringPeriod;
    }

    public long getDuration() {
        return this.durationMillis;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Time) {
            Time other = (Time)obj;
            return other.durationMillis == this.durationMillis && other.earlyTriggeringPeriod == this.earlyTriggeringPeriod;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.durationMillis, this.earlyTriggeringPeriod);
    }
}

