/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.dataset.windowing;

import cz.seznam.euphoria.core.client.dataset.windowing.Window;

public final class TimeInterval
extends Window<TimeInterval> {
    private final long startMillis;
    private final long endMillis;

    public TimeInterval(long startMillis, long endMillis) {
        this.startMillis = startMillis;
        this.endMillis = endMillis;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public long getEndMillis() {
        return this.endMillis;
    }

    public long getDurationMillis() {
        return this.endMillis - this.startMillis;
    }

    boolean intersects(TimeInterval that) {
        return this.startMillis < that.endMillis && this.endMillis > that.startMillis;
    }

    TimeInterval cover(TimeInterval that) {
        return new TimeInterval(Math.min(this.startMillis, that.startMillis), Math.max(this.endMillis, that.endMillis));
    }

    @Override
    public long maxTimestamp() {
        return this.endMillis;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeInterval)) {
            return false;
        }
        TimeInterval that = (TimeInterval)o;
        return this.startMillis == that.startMillis && this.endMillis == that.endMillis;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.startMillis ^ this.startMillis >>> 32);
        result = 31 * result + (int)(this.endMillis ^ this.endMillis >>> 32);
        return result;
    }

    public String toString() {
        return "TimeInterval{startMillis=" + this.startMillis + ", endMillis=" + this.endMillis + '}';
    }

    @Override
    public int compareTo(TimeInterval o) {
        long cmp = this.startMillis - o.startMillis;
        if (cmp != 0L) {
            return cmp < 0L ? -1 : 1;
        }
        cmp = this.endMillis - o.endMillis;
        if (cmp == 0L) {
            return 0;
        }
        return cmp < 0L ? -1 : 1;
    }
}

