/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.dataset.windowing;

import cz.seznam.euphoria.core.client.dataset.windowing.TimeInterval;
import cz.seznam.euphoria.core.client.dataset.windowing.WindowedElement;
import cz.seznam.euphoria.core.client.dataset.windowing.Windowing;
import cz.seznam.euphoria.core.client.io.Collector;
import cz.seznam.euphoria.core.client.triggers.TimeTrigger;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.shadow.com.google.common.base.Preconditions;
import cz.seznam.euphoria.shadow.com.google.common.collect.AbstractIterator;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;

public final class TimeSliding<T>
implements Windowing<T, TimeInterval> {
    private final long duration;
    private final long slide;

    public static <T> TimeSliding<T> of(Duration duration, Duration step) {
        return new TimeSliding<T>(duration.toMillis(), step.toMillis());
    }

    public static TimeInterval getLabel(Collector<?> context) {
        return (TimeInterval)context.getWindow();
    }

    private TimeSliding(long duration, long slide) {
        this.duration = duration;
        this.slide = slide;
        Preconditions.checkArgument(duration > 0L, "Windowing with zero duration");
        if (duration % slide != 0L) {
            throw new IllegalArgumentException("This time sliding window can manage only aligned sliding windows");
        }
    }

    @Override
    public Iterable<TimeInterval> assignWindowsToElement(WindowedElement<?, T> el) {
        return new SlidingWindowSet(el.getTimestamp(), this.duration, this.slide);
    }

    @Override
    public Trigger<TimeInterval> getTrigger() {
        return new TimeTrigger();
    }

    public String toString() {
        return "TimeSliding{duration=" + this.duration + ", slide=" + this.slide + '}';
    }

    public long getDuration() {
        return this.duration;
    }

    public long getSlide() {
        return this.slide;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSliding) {
            TimeSliding other = (TimeSliding)obj;
            return other.duration == this.duration && other.slide == this.slide;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.slide);
    }

    public static class SlidingWindowSet
    implements Iterable<TimeInterval> {
        private final long elementStamp;
        private final long duration;
        private final long slide;

        public SlidingWindowSet(long elementStamp, long duration, long slide) {
            this.elementStamp = elementStamp;
            this.duration = duration;
            this.slide = slide;
        }

        @Override
        public Iterator<TimeInterval> iterator() {
            return new AbstractIterator<TimeInterval>(){
                private long start;
                {
                    this.start = elementStamp - elementStamp % slide;
                }

                @Override
                protected TimeInterval computeNext() {
                    TimeInterval window = null;
                    if (this.start > elementStamp - duration) {
                        window = new TimeInterval(this.start, this.start + duration);
                        this.start -= slide;
                    } else {
                        this.endOfData();
                    }
                    return window;
                }
            };
        }
    }
}

