/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.io;

import cz.seznam.euphoria.core.client.io.DataSink;
import cz.seznam.euphoria.core.client.io.Writer;
import java.io.IOException;
import java.io.PrintStream;

public class StdoutSink<T>
implements DataSink<T> {
    static final long START_SYSTEM_NANO_TIME = System.nanoTime();
    private final boolean debug;
    private final String discriminator;

    public StdoutSink() {
        this(false);
    }

    public StdoutSink(boolean debug) {
        this(debug, null);
    }

    public StdoutSink(boolean debug, String discriminator) {
        this.debug = debug;
        this.discriminator = discriminator;
    }

    @Override
    public Writer<T> openWriter(int partitionId) {
        PrintStream out = System.out;
        return this.debug ? new DebugWriter(out, partitionId, false, this.discriminator) : new PlainWriter(out, false);
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public void rollback() {
    }

    static final class DebugWriter<T>
    extends AbstractWriter<T> {
        final int partitionId;
        final StringBuilder buf = new StringBuilder();
        final int bufResetPos;

        DebugWriter(PrintStream out, int partitionId, boolean doClose, String discriminator) {
            super(out, doClose);
            this.partitionId = partitionId;
            if (discriminator != null && !discriminator.isEmpty()) {
                this.buf.append(discriminator).append("> ");
            }
            this.bufResetPos = this.buf.length();
        }

        @Override
        public void write(T elem) throws IOException {
            this.buf.setLength(this.bufResetPos);
            this.buf.append((double)(System.nanoTime() - START_SYSTEM_NANO_TIME) / 1.0E9).append(": (").append(Thread.currentThread().getName()).append(") [").append(this.partitionId).append("] (#").append(System.identityHashCode(elem)).append(") {").append(elem == null ? null : elem.getClass()).append("}: ").append(elem);
            this.out.println(this.buf);
        }
    }

    static final class PlainWriter<T>
    extends AbstractWriter<T> {
        PlainWriter(PrintStream out, boolean doClose) {
            super(out, doClose);
        }

        @Override
        public void write(T elem) throws IOException {
            this.out.println(elem);
        }
    }

    static abstract class AbstractWriter<T>
    implements Writer<T> {
        final PrintStream out;
        final boolean doClose;

        AbstractWriter(PrintStream out, boolean doClose) {
            this.out = out;
            this.doClose = doClose;
        }

        @Override
        public void commit() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.doClose) {
                this.out.close();
            }
        }
    }
}

