/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.operator;

import cz.seznam.euphoria.core.client.dataset.Dataset;
import cz.seznam.euphoria.core.client.functional.BinaryFunctor;
import cz.seznam.euphoria.core.client.functional.UnaryFunction;
import cz.seznam.euphoria.core.client.operator.Join;
import java.util.Objects;
import java.util.Optional;

public class LeftJoin {
    public static <LEFT, RIGHT> ByBuilder<LEFT, RIGHT> of(Dataset<LEFT> left, Dataset<RIGHT> right) {
        return new OfBuilder("LeftJoin").of(left, right);
    }

    public static OfBuilder named(String name) {
        return new OfBuilder(name);
    }

    public static class UsingBuilder<LEFT, RIGHT, KEY> {
        private final String name;
        private final Dataset<LEFT> left;
        private final Dataset<RIGHT> right;
        private final UnaryFunction<LEFT, KEY> leftKeyExtractor;
        private final UnaryFunction<RIGHT, KEY> rightKeyExtractor;

        UsingBuilder(String name, Dataset<LEFT> left, Dataset<RIGHT> right, UnaryFunction<LEFT, KEY> leftKeyExtractor, UnaryFunction<RIGHT, KEY> rightKeyExtractor) {
            this.name = name;
            this.left = left;
            this.right = right;
            this.leftKeyExtractor = leftKeyExtractor;
            this.rightKeyExtractor = rightKeyExtractor;
        }

        public <OUT> Join.WindowingBuilder<LEFT, RIGHT, KEY, OUT> using(BinaryFunctor<LEFT, Optional<RIGHT>, OUT> functor) {
            BinaryFunctor wrappedFunctor = (left, right, context) -> functor.apply(left, Optional.ofNullable(right), context);
            return new Join.WindowingBuilder(this.name, this.left, this.right, this.leftKeyExtractor, this.rightKeyExtractor, wrappedFunctor, Join.Type.LEFT);
        }
    }

    public static class ByBuilder<LEFT, RIGHT> {
        private final String name;
        private final Dataset<LEFT> left;
        private final Dataset<RIGHT> right;

        ByBuilder(String name, Dataset<LEFT> left, Dataset<RIGHT> right) {
            this.name = Objects.requireNonNull(name);
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        public <KEY> UsingBuilder<LEFT, RIGHT, KEY> by(UnaryFunction<LEFT, KEY> leftKeyExtractor, UnaryFunction<RIGHT, KEY> rightKeyExtractor) {
            return new UsingBuilder<LEFT, RIGHT, KEY>(this.name, this.left, this.right, leftKeyExtractor, rightKeyExtractor);
        }
    }

    public static class OfBuilder {
        private final String name;

        OfBuilder(String name) {
            this.name = name;
        }

        public <LEFT, RIGHT> ByBuilder<LEFT, RIGHT> of(Dataset<LEFT> left, Dataset<RIGHT> right) {
            if (right.getFlow() != left.getFlow()) {
                throw new IllegalArgumentException("Pass inputs from the same flow");
            }
            return new ByBuilder<LEFT, RIGHT>(this.name, left, right);
        }
    }
}

