/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.operator;

import cz.seznam.euphoria.core.annotation.operator.Basic;
import cz.seznam.euphoria.core.annotation.operator.StateComplexity;
import cz.seznam.euphoria.core.client.dataset.Dataset;
import cz.seznam.euphoria.core.client.flow.Flow;
import cz.seznam.euphoria.core.client.operator.Builders;
import cz.seznam.euphoria.core.client.operator.Operator;
import cz.seznam.euphoria.shadow.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Basic(state=StateComplexity.ZERO, repartitions=0)
public class Union<IN>
extends Operator<IN, IN> {
    private final List<Dataset<IN>> dataSets;
    final Dataset<IN> output;

    @SafeVarargs
    public static <IN> OutputBuilder<IN> of(Dataset<IN> ... dataSets) {
        return Union.of(Arrays.asList(dataSets));
    }

    public static <IN> OutputBuilder<IN> of(List<Dataset<IN>> dataSets) {
        return new OfBuilder("Union").of(dataSets);
    }

    public static OfBuilder named(String name) {
        return new OfBuilder(name);
    }

    Union(String name, Flow flow, List<Dataset<IN>> dataSets) {
        super(name, flow);
        Preconditions.checkArgument(dataSets.size() > 1, "Union needs at least two data sets.");
        Preconditions.checkArgument(dataSets.stream().map(Dataset::getFlow).distinct().count() == 1L, "Only data sets from the same flow can be passed to Union.");
        this.dataSets = dataSets;
        this.output = this.createOutput(dataSets.get(0));
    }

    @Override
    public Dataset<IN> output() {
        return this.output;
    }

    @Override
    public Collection<Dataset<IN>> listInputs() {
        return this.dataSets;
    }

    public static class OutputBuilder<IN>
    implements Builders.Output<IN> {
        private final String name;
        private final List<Dataset<IN>> dataSets;

        OutputBuilder(String name, List<Dataset<IN>> dataSets) {
            Preconditions.checkArgument(dataSets.size() > 1, "Union needs at least two data sets.");
            Preconditions.checkArgument(dataSets.stream().map(Dataset::getFlow).distinct().count() == 1L, "Only data sets from the same flow can be passed to Union.");
            this.name = Objects.requireNonNull(name);
            this.dataSets = dataSets;
        }

        @Override
        public Dataset<IN> output() {
            Flow flow = this.dataSets.get(0).getFlow();
            Union<IN> union = new Union<IN>(this.name, flow, this.dataSets);
            flow.add(union);
            return union.output();
        }
    }

    public static class OfBuilder {
        private final String name;

        OfBuilder(String name) {
            this.name = name;
        }

        @SafeVarargs
        public final <IN> OutputBuilder<IN> of(Dataset<IN> ... dataSets) {
            return this.of(Arrays.asList(dataSets));
        }

        public <IN> OutputBuilder<IN> of(List<Dataset<IN>> dataSets) {
            return new OutputBuilder<IN>(this.name, dataSets);
        }
    }
}

